import gradio as gr
import os
import subprocess
import shutil
import openai

css_style = """
.gradio-container {
    font-family: "IBM Plex Mono";
}
"""

def process_repository(url, model):

    
    # Split the URL to get the repo name
    repo_name = url.split('/')[-1]
    if repo_name.endswith('.git'):
        repo_name = repo_name[:-4]

    # Change permissions
    subprocess.run(['chmod', 'u+w', '.'])
    
    # Clone the repo
    subprocess.run(['git', 'clone', url], check=True)

    try:
        # Change directory to the cloned repo
        os.chdir(repo_name)

        # Run your package command
        subprocess.run(['gpt4readability', '.', '--function', 'readme','--include-md', 'false', '--model', model])

        # Open the README.md file and return its contents
        with open('README.md', 'r') as readme_file:
            readme_contents = readme_file.read()

        return readme_contents
    finally:
        # Change back to the original directory
        os.chdir('..')

        # Delete the repo directory
        if os.path.exists(repo_name):
            shutil.rmtree(repo_name)

def generate_repo(url, api_key, model):
    if api_key:
        os.environ['OPENAI_API_KEY'] = api_key.strip()
        # if model == 'gpt-4':
        #     try:
        #         response = openai.Completion.create(
        #             model="gpt-4",  # or whatever the exact model ID is
        #             prompt="test",
        #             max_tokens=5
        #         )
        #         print("Access to GPT-4 confirmed!")
        #     except:
        #         return "The API key either does not have access to GPT-4 or is not valid."
        return process_repository(url, model)
    else:
        return "Please add a valid OpenAI API Key (you can get them [here](https://platform.openai.com/account/api-keys))"

with gr.Blocks(css=css_style) as demo:
    gr.Markdown(f"""
        # Hello from GPT4Readability (v0.1.3)

        *Project by Dennis Loevlie ([@DennisLoevlie](https://twitter.com/DennisLoevlie))*  
        [![License Badge](https://img.shields.io/github/license/loevlie/GPT4Readability)](https://github.com/loevlie/GPT4Readability/blob/main/LICENSE)

        Welcome to GPT4Readability, a tool designed to help you generate README.md files and suggest improvements for your code repositories.

        - You can find the source code at [GPT4Readability](https://github.com/loevlie/GPT4Readability).
        - It's making use of the [langchain](https://github.com/hwchase17/langchain) library.

        ## Here's how to get started:
        1. Please enter your API Key ([Need more information?](https://platform.openai.com/account/api-keys))
        2. Provide the GitHub Repository URL that you'd like to analyze
        3. Select a model (Please note, the gpt-4 API isn't available to all as of July 2023)
        4. Click to generate a README or suggestions markdown file
        """)

    openai_api_key = gr.Textbox(
            label="OpenAI API Key", placeholder="sk-...", type="password")
    url = gr.Textbox(label="GitHub Repository URL")
    model = gr.Dropdown(["gpt-3.5-turbo", "gpt-4"], type="value", label='Model Type')
    output = gr.Markdown(label="README.md")
    btn = gr.Button("Generate README.md")
    btn.click(fn=generate_repo, inputs=[url, openai_api_key, model], outputs=[output], api_name="Generate README.md")
    

demo.queue(concurrency_count=20)
demo.launch(share=False)