from transformers import pipeline
import gradio as gr

pipe = pipeline('text-generation', model='daspartho/prompt-extend')

def extend_prompt(prompt):
    return pipe(prompt+',', num_return_sequences=1)[0]["generated_text"]

examples = [
            ['elon musk as thor'],
            ["giant dragon flying in the sky"],
            ['psychedelic liquids space'],
            ["a coconut laying on the beach"],
            ["peaceful village landscape"],
            ]

iface = gr.Interface(
    description = "Enter a main idea for a prompt, and the model will attempt to add suitable style cues.",
    article = "<p style='text-align: center'><a href='https://github.com/daspartho/prompt-extend' target='_blank'>Github</a></p>",
    fn=extend_prompt, 
    inputs=gr.Text(label="Type the prompt here"), 
    outputs=gr.TextArea(label='Extended prompt'),
    examples=examples,
    title="Prompt Extend"
    )

iface.launch()