import traceback, os
import numpy as np
import librosa
from datetime import datetime
from config import device
from vc_infer_pipeline import VC
import model_prepare

def create_voice_cloner(target_sr, gen_model, if_fund_freq, feature_ratio, file_big_npy, is_half, files=False):
    time_limit = os.getenv("SYSTEM") == "spaces" 
    def voice_cloner_function(
        uploaded_audio,
        example_audio,
        pitch_shift_semi_up_key,
        pitch_shift_method,
        fn_feature_ratio,
        vc_input_type_radio,
    # def voice_cloner_function(
    #     input_audio,
    #     pitch_shift_semi_up_key,
    #     pitch_shift_method,
    #     fn_feature_ratio,
    ):
        try:
            input_audio = uploaded_audio
            if(vc_input_type_radio == "Uploaded"):
                input_audio = uploaded_audio
                print("Using uploaded audio, vc_input_type_radio.value: ", vc_input_type_radio)
            elif(vc_input_type_radio == "Example"):
                input_audio = example_audio
                print("Using example audio, vc_input_type_radio.value: ", vc_input_type_radio)
            
            
            if files:
                audio, sr = librosa.load(input_audio, sr=16000, mono=True)
            else:
                if input_audio is None:
                    return "Please upload a sound file", None
                sampling_rate, audio = input_audio
                duration = audio.shape[0] / sampling_rate
                if duration > 20:
                    return "Please upload a sound file that is less than 20 seconds.", None
                audio = (audio / np.iinfo(audio.dtype).max).astype(np.float32)
                if len(audio.shape) > 1:
                    audio = librosa.to_mono(audio.transpose(1, 0))
                if sampling_rate != 16000:
                    audio = librosa.resample(audio, orig_sr=sampling_rate, target_sr=16000)
            times = [0, 0, 0]
            
            pitch_shift_semi_up_key = int(pitch_shift_semi_up_key)
            vc = VC(target_sr, device, is_half)
            hubert_model = model_prepare.load_hubert()
            audio_opt = vc.pipeline(
                hubert_model,
                gen_model,
                0,
                audio,
                times,
                pitch_shift_semi_up_key,
                pitch_shift_method,
                feature_ratio,
                file_big_npy,
                fn_feature_ratio,
                if_fund_freq,
            )
            print(
                f"[{datetime.now().strftime('%Y-%m-%d %H:%M')}]: npy: {times[0]}, f0: {times[1]}s, infer: {times[2]}s"
            )
            return "Success", (target_sr, audio_opt)
        except:
            info = traceback.format_exc()
            print(info)
            return info, (None, None)
    return voice_cloner_function

    def create_voice_cloner_all():
        models = model_prepare.get_all_models()
        voice_cloner_functions = []
        for model in models:
            name, title, author, cover, voice_cloner_function = model
            voice_cloner_functions.append(voice_cloner_function)
        return voice_cloner_functions