import torch
from fairseq import checkpoint_utils
import json
from infer_pack.models import SynthesizerTrnMs256NSFsid, SynthesizerTrnMs256NSFsid_nono
from vc_infer_pipeline import VC
from config import (
    is_half,
    device
)

def get_model_info(model_name):
    with open("weights/model_info.json", "r", encoding="utf-8") as f:
        models_info = json.load(f)
    # For now, get first item
    name, info = next(iter(models_info.items()))
    name = model_name
    # name = "Girl_1"
    info = models_info[name]

    title = "Voice Model Image:  &nbsp;  " + "GPT-4's Grandmother"
    author = info.get("author", None)
    image = f"weights/{name}/{info['image']}"
    feature_retrieval_index = f"weights/{name}/{info['feature_retrieval_library']}"
    npy = f"weights/{name}/{info['feature_file']}"
    checkpoint = torch.load(f"weights/{name}/{name}.pth", map_location="cpu")
    target_sr = checkpoint["config"][-1]
    checkpoint["config"][-3] = checkpoint["weight"]["emb_g.weight"].shape[0]  # n_spk
    if_fund_freq = checkpoint.get("f0", 1)
    if if_fund_freq == 1:
        gen_model = SynthesizerTrnMs256NSFsid(*checkpoint["config"], is_half=is_half)
    else:
        gen_model = SynthesizerTrnMs256NSFsid_nono(*checkpoint["config"])
    del gen_model.enc_q
    print(gen_model.load_state_dict(checkpoint["weight"], strict=False)) 
    gen_model.eval().to(device)
    if is_half:
        gen_model = gen_model.half()
    else:
        gen_model = gen_model.float()

    return name, title, author, image, feature_retrieval_index, npy, target_sr, if_fund_freq, is_half, gen_model

# make a struct to hold all the info returned from get_model_info
class ModelInfo:
    def __init__(self, name, title, author, image, feature_retrieval_index, npy, target_sr, if_fund_freq, is_half, gen_model):
        self.name = name
        self.title = title
        self.author = author
        self.image = image
        self.feature_retrieval_index = feature_retrieval_index
        self.npy = npy
        self.target_sr = target_sr
        self.if_fund_freq = if_fund_freq
        self.is_half = is_half
        self.gen_model = gen_model
    
def unpack_model_info(model_info):
    return model_info.name, model_info.title, model_info.author, model_info.image, model_info.gen_model


def get_all_model_infos():
    model_infos = []
    with open("weights/model_info.json", "r", encoding="utf-8") as f:
        models_info = json.load(f)
        #loop through all models in model_info.json
        for name, info in models_info.items():
            name, title, author, image, feature_retrieval_index, npy, target_sr, if_fund_freq, is_half, gen_model = get_model_info(model_name=name)
            model_infos.append(ModelInfo(name, title, author, image, feature_retrieval_index, npy, target_sr, if_fund_freq, is_half, gen_model))
            # print ("\nname: ", name, "\n")
    return model_infos
    


def load_hubert():
    global hubert_model
    models, _, _ = checkpoint_utils.load_model_ensemble_and_task(
        ["hubert_base.pt"],
        suffix="",
    )
    hubert_model = models[0]
    hubert_model = hubert_model.to(device)
    if is_half:
        hubert_model = hubert_model.half()
    else:
        hubert_model = hubert_model.float()
    hubert_model.eval()
    return hubert_model 
        

