#Nvidia or Apple silicon
device = "cuda:0"

#For all nvida 10 series onwards, use half precision
is_half = True

# use all threads
n_cpu = 0

#Command-line Parameters
import argparse

parser = argparse.ArgumentParser()
parser.add_argument("--port", type=int, default=7865, help="Listen port")
parser.add_argument("--pycmd", type=str, default="python", help="Python command")
parser.add_argument("--colab", action="store_true", help="Launch in colab")
parser.add_argument(
    "--noparallel", action="store_true", help="Disable parallel processing"
)
parser.add_argument(
    "--noautoopen", action="store_true", help="Do not open in browser automatically"
)
cmd_opts, unknown = parser.parse_known_args()

python_cmd = cmd_opts.pycmd
listen_port = cmd_opts.port
iscolab = cmd_opts.colab
noparallel = cmd_opts.noparallel
noautoopen = cmd_opts.noautoopen

import sys
import torch

# has_mps is only available in nightly pytorch (for now) and MasOS 12.3+.
# check `getattr` and try it for compatibility
def has_mps() -> bool:
    if sys.platform != "darwin":
        return False
    else:
        if not getattr(torch, "has_mps", False):
            return False
        try:
            torch.zeros(1).to(torch.device("mps"))
            return True
        except Exception:
            return False


if not torch.cuda.is_available():
    if has_mps():
        print("No Nvidia support, using MPS")
        device = "mps"
    else:
        print("No Nvidia support, using CPU")
        device = "cpu"
        is_half = False

if device not in ["cpu", "mps"]:
    gpu_name = torch.cuda.get_device_name(int(device.split(":")[-1]))
    if "16" in gpu_name or "MX" in gpu_name:
        print("For 16 series graphics cards/MX series graphics cards, force single precision")
        is_half = False

from multiprocessing import cpu_count

if n_cpu == 0:
    n_cpu = cpu_count()
if is_half:
    # 6GB VRAM configuration
    x_pad = 3
    x_query = 10
    x_center = 60
    x_max = 65
else:
    # 5GB VRAM configuration
    x_pad = 1
    x_query = 6
    x_center = 38
    x_max = 41
