import os
import argparse
import logging
logging.getLogger("numba").setLevel(logging.ERROR)
import gradio as gr
import model_prepare
import voice_cloner
#import whisper
import librosa


if __name__ == '__main__':

    files=False
    model_cloners = []
    

    # ... OR Load ALL model_infos from weights/model_info.json
    model_infos = model_prepare.get_all_model_infos()
    for model_info in model_infos:
        # print ("\nname: ", model_info.name, "\n")
        # get the info for this model 
        # name, title, author, image, feature_retrieval_index, npy, target_sr, if_fund_freq, is_half, gen_model = model_prepare.unpack_model_info(model_info)
        name, title, author, image, feature_retrieval_index, npy, target_sr, if_fund_freq, is_half, gen_model = model_prepare.get_model_info(model_info.name)
        # build a cloner  for this model
        model_cloner = voice_cloner.create_voice_cloner(target_sr, gen_model, if_fund_freq, feature_retrieval_index, npy, is_half, files=files)
       # add the model and cloner function to the list of models
        model_cloners.append((name, title, author, image, model_cloner))
        print ("\nname: ", model_info.name)

    num_models = len(model_cloners)
    print("num_models: ", num_models)

    #-------------------------------------------------------------------------
    #                          Web Page Layout
    #       Create the layout in different block sections using Gradio
    #-------------------------------------------------------------------------
    with gr.Blocks() as app:

        #--------   Headings  ---------
        gr.Markdown(
            "# <center> Voice Cloner\n"
            "## <center> Upload a solo voice sample.\n"
            "<div style='text-align: right; font-size: 16px; margin-left: 10%; '>"
            "<a href='http://ai.muringer.com/'>AI Muringer</a><br/> "
            "<a href='https://AudioNetAI.com/'>AudioNet AI</a>"
            "</div>"                                                
            '<div align="center">'
            f'<div>{title}</div>\n'+
            #(f'<div>Model author: &nbsp; {author}</div>' if author else "")+
            (f'<img style="width:auto;height:300px;" src="file/{"waveform_pic.png"}">' if "waveform_pic.png" else "")+
            '</div>'
        )
        # Make a row of 2 Web Layout Colums:  Input stuff   |   Output stuff
        with gr.Row():
            #---------------------------
            #       Input column
            #---------------------------
            with gr.Column(variant="panel"):
                gr.Markdown(
                  "\n <center>.   \n"
                  "  \n\n\n # <center> Input"  
                  "\n#### <center>[Upload a solo voice sample: max 20 seconds])\n"  
                  "<br/>"
                )

                example_audio = gr.Audio(label="Example: calvin_harris_-_how_deep_is_your_love.wav", value="calvin_harris_-_how_deep_is_your_love.wav")
                uploaded_audio = gr.Audio(label="Input audio (max 20 seconds)")

                vc_input_type_radio = gr.Radio(
                    label="Choose the example file  or upload your own audio file",
                    choices=["Example", "Uploaded"],
                    value="Example",
                    interactive=True,
                )
            #---------------------------
            #       Outputs column
            #---------------------------
            with gr.Column(variant="default"):
                gr.Markdown(
                    "\n <center>.   \n"
                    "  \n\n\n # <center> Output"  
                    "\n#### <center>[Revoiced as another person]\n"  
                    )
                for i in range(num_models): 
                    with gr.Row(variant="panel"):
                        name, title, author, image, model_cloner = model_cloners[i]
                        with gr.Row(variant="panel"):
                            
                            #gr.Button.style(self, full_width = True)
                            #--------   Model Button  ---------
                            apply_model_button = gr.Button(f"{name} ", variant="primary")
                            
                            #--------   Transpose Slider  ---------
                            vc_transpose = 0
                            vc_transpose = gr.Slider(
                                minimum=-12,
                                maximum=12,
                                step=1,
                                label="Transpose",
                                value=0,
                                interactive=True,
                            )
                            with gr.Box(visible=False):
                                #--------   Algo  ---------
                                vc_f0method = "Praat"
                                vc_f0method = gr.Radio(
                                    label="Pitch algorithhm ",
                                    choices=["Praat", "Harvest"],
                                    value="Praat",
                                    interactive=True,
                                )
                                vc_f0method.update(visible=False)
                                #--------   Feature Ratio  ---------
                                vc_feature_ratio = 0.6
                                vc_feature_ratio = gr.Slider(
                                    minimum=0,
                                    maximum=1,
                                    label="Retrieval feature ratio",
                                    value=0.6,
                                    interactive=True,
                                )
                                vc_feature_ratio.update(visible=False)

                            # gr.Markdown(
                            #     (f'<div>Model author: &nbsp; {author}</div>' if author else "")
                            # )

                            cloner_text_output = gr.Textbox(label=f"[Author:              {author}]")
                            cloner_audio_ouput = gr.Audio(label="Output Audio")
                            
                            function = model_cloner

                            inputs = [uploaded_audio, example_audio, vc_transpose, vc_f0method, vc_feature_ratio, vc_input_type_radio]
                            outputs = [cloner_text_output, cloner_audio_ouput]
                            # Finally we have eveything we need to create the app: (function, inputs, outputs)
                            apply_model_button.click(function, inputs=inputs, outputs=outputs) 
    #----------------------------------  End of Layout  -------------------------------------------

    api_open=False
    share = False
    app.queue(concurrency_count=1, max_size=20, api_open=api_open).launch(share=share)