import gradio as gr
from PIL import Image
import os
import upscale
from pathlib import Path

root_dir = "ESRGAN"
output_dir = "output"
input_dir = "input"
# Define function to process image
def process_image(input_image):
    # print(input_image)
    # print(os.path.join(root_dir, output_dir))
    # print("The type of image: ", type(input_image))

    # Save image to directory
    input_image.save(os.path.join(input_dir, "image.png"), format="PNG")

    # Run instance from upscale
    upscale.main(model=str("models/4xArabicText.pth"), 
                 cpu=True, 
                 input=Path("input"),
                 output=Path("output"),
                 reverse=False,
                 skip_existing=False,
                 delete_input=False,
                 seamless=None,
                 fp16=False,
                 device_id=0,
                 cache_max_split_depth=False,
                 binary_alpha=False,
                 ternary_alpha=False,
                 alpha_threshold=0.5,
                 alpha_boundary_offset=0.2,
                 alpha_mode=None,
                 verbose=False)

    # Open image from dir
    img = Image.open(os.path.join(output_dir, "image.png"))    

    return img

# Create gradio app content
title = "ArText Upscaling | ArabicText 0.0.1a"
description = "<p style='text-align: center; font-size: 1rem'>This app will be used to upscale image up to 4x the original size, Please be patient the process may take upto 5 minute.<div style='text-align: center; font-color: red'>PS: Project still in alpha release!</div></p>"
footer = "<div style='text-align: center; font-size: 1rem'>This app made by Yousif. Check my social media <a href='https://twitter.com/Joxdrink' target='_blank'>@Twitter</a>, <a href='https://github.com/Jo0xFF' target='_target'>@Github</a>"

gr_app = gr.Interface(fn=process_image, 
                      inputs=gr.Image(type="pil"),
                      outputs=gr.Image(type="pil", shape=(720, 1280)),
                      title=title,
                      description=description,
                      article=footer,
                      theme=gr.themes.Soft(),
                      allow_flagging="never")


gr_app.queue(max_size=16).launch(debug=True)