# Author: Jingqi
# Create datetime: 2023/10/2 11:38
import openai
import logging


class ChatgptAPI:
    def __init__(self, api_key):
        openai.api_key = api_key

    def get_single_completion(self, prompt, model='gpt-3.5-turbo'):
        messages = [{"role": "user", "content": prompt}]
        response = openai.ChatCompletion.create(
            model=model,
            messages=messages,
            temperature=0,
            max_tokens=2048,
            top_p=1,
        )
        return response.choices[0].message['content']

    def get_multi_round_completion(self, prompt, conversation, model='gpt-3.5-turbo'):
        conversation.append_question(prompt)
        prompts = conversation.get_prompts()

        response = openai.ChatCompletion.create(
            model=model,
            messages=prompts,
            temperature=0,
            max_tokens=2048,
            top_p=1,
        )
        message = response.choices[0].message['content']
        conversation.append_answer(message)

        return message, conversation


class Conversation:
    def __init__(self, system_prompt='', num_of_round=5):
        self.num_of_round = num_of_round
        self.history = []
        self.initialized = False
        self.history.append({"role": "system", "content": system_prompt})

        # if len(system_prompt) > 0:
        #     logger.info(f'Conversation initialized with system prompt: {system_prompt}')
        #     self.initialized = True

    def is_initialized(self):
        return self.initialized

    def append_question(self, question):
        self.history.append({"role": "user", "content": question})

    def append_answer(self, answer):
        self.history.append({"role": "assistant", "content": answer})

        if len(self.history) > self.num_of_round * 2:
            del self.history[1:3]

    def clear(self):
        self.history.clear()
        self.initialized = False

    def get_prompts(self):
        return self.history

    def round_size(self):
        return 0 if len(self.history) < 2 else len(self.hitory) - 1

    def get_history_messages(self):
        return [(u['content'], b['content']) for u, b in zip(self.history[1::2], self.history[2::2])]
