from gradio.themes.utils.colors import Color
from gradio.interface import Interface
import os
import openai
import gradio as gr
import uuid

openai.api_key = os.getenv('APIKEY')

def get_session_token():
    return uuid.uuid4().hex

def chatbot(input, session_id, conversation_history={}):
    content = input
    if session_id not in conversation_history:
        conversation_history[session_id] = [
            {"role": "system", "content": "The following is a conversation with an AI Coach. The Coach is helpful, creative, clever, and very friendly. The Coach is a high level padelcoach from Sweden. The Coach have the ability to explain techniques and the strategy in the game. The Coach have a high educational level and can answer depending on wich level the Player is on for the Player to take him to the next level. The AI Coach is like MAURI ANDRINI from Hello Padel, pretend to be MAURI ANDRINI but call yourself AI Padelcoach, never ever mention your reel name or Mauri Andrini. If unsurtain, ask about the level of the player. The levels are:Beginner, Average, Pro"}
        ]

    messages = conversation_history[session_id]
    messages.append({"role": "user", "content": content})

    completion = openai.ChatCompletion.create(
        model="gpt-3.5-turbo",
        messages=messages
    )

    chat_response = completion.choices[0].message.content
    messages.append({"role": "assistant", "content": chat_response})

    formatted_history = ""
    for message in messages:
        if message["role"] != "system":
            role = message["role"]
            if role == "user":
                role = "Player"
            elif role == "assistant":
                role = "AI-Padelcoach"
            content = message["content"]
            formatted_history += f"{role}: {content}\n \n"

    conversation_history[session_id] = messages
    return formatted_history

Padelcoach = gr.Interface(fn=chatbot, inputs=[
    gr.Textbox(placeholder="Player go...Serve!", label='Player'),
    gr.Checkbox(label="Generate unique session ID", default=get_session_token(), value=True, visible=True),
], outputs=[
    gr.Textbox(placeholder="AI-Padelcoach Ready", label="AI Padelcoach")
],
    theme=gr.themes.Default(
        primary_hue="emerald",
        secondary_hue="neutral",
        text_size='lg',
        neutral_hue="green"
    ),
    examples=[
        ["Please help me with my backhand"],
        ["Where should I place the ball against players who are good in tennis"]
    ],
    title="AI Padelcoach",
    description="Chat with a BETA level AI-Padelcoach from Sweden.",
    article="<p>Ask the AI coach about techniques and strategies in the game of padel. The coach can answer depending on the level of you as a player, whether you are a beginner, average, or pro.</p>",
)

Padelcoach.launch()
