# AUTOGENERATED! DO NOT EDIT! File to edit: . (unless otherwise specified).

__all__ = ['repo_id', 'learn', 'classify_image', 'categories', 'title', 'description', 'article', 'image', 'label',
           'examples', 'intf']

# Cell
import timm
from fastai.vision.all import *
import gradio as gr

# Cell
from huggingface_hub import from_pretrained_fastai

repo_id = "Jimmie/identify-this-insect"

learn = from_pretrained_fastai(repo_id)

# Cell
categories = learn.dls.vocab

def classify_image(img):
    pred,idx,probs = learn.predict(img)
    return dict(zip(categories, map(float, probs)))
 
# Cell

title = "Identify This Insect"
description = """

This demo was created to distinguish between three types of insects: 'caterpillar', 'centipede', and 'millipede'.

It is just a toy app created mostly because I once got a caterpillar sting and thought that the insect was a centipede and I was scared until I
googled how different a centipede looks from a caterpillar haha! (The insect that had stung me looked more like the fourth example image below).

Enjoy!


"""

article = "Check out how the model was trained: [Training Notebook](https://github.com/jimmiemunyi/deeplearning-experiments/blob/main/notebooks/Centipede_vs_Millipede_vs_Caterpillar.ipynb)."
image = gr.inputs.Image(shape=(224,224))
label = gr.outputs.Label()
examples = ['caterpillar.jpg', 'centipede.jpg', 'millipede.jpg', 'caterpillar-2.jpg']

intf = gr.Interface(fn=classify_image, inputs=image, outputs=label, examples=examples, title = title, description = description, article = article,
enable_queue=True, cache_examples=False)
intf.launch()