#Librerias para cargar imagenes
import numpy as np
from keras.preprocessing.image import load_img, img_to_array
from keras.models import load_model
import streamlit as st

dim = 200
modelo = './modelo.h5'
pesos = './pesos.h5'
cnn = load_model(modelo)
cnn.load_weights(pesos)

st.title("Upload + Classification Example")
uploaded_file = st.file_uploader("Choose an image...", type="jpg")
if uploaded_file is not None:
    image = Image.open(uploaded_file)
    st.image(image, caption='Uploaded Image.', use_column_width=True)
    st.write("")
    st.write("Classifying...")
    label = predict(uploaded_file) ##aqui va el llamado a la IA
    st.write('%s (%.2f%%)' % (label[1], label[2]*100))

def clasificar(uploaded_file):
  x = load_img(uploaded_file, target_size=(dim, dim), color_mode = "grayscale")
  x = img_to_array(x)
  x = np.expand_dims(x, axis=0)
  arreglo = cnn.predict(x)
  resultado = arreglo[0]
  respuesta = np.argmax(resultado)

  if respuesta==0:
    print('NORMAL')
  else:
    print('TUMOR CEREBRAL')

  return respuesta

clasificar(uploaded_file)