import gradio as gr
import cv2 
import requests
import os 
import random

from ultralytics import YOLO

file_urls = [
    'https://www.dropbox.com/scl/fi/o0p2ulnq19hh896bdnlha/DJI_0310.jpg?rlkey=xng4o5rsmzr8mezalfsyggiev&dl=1',
    'https://www.dropbox.com/scl/fi/93y1i7fpp0byomnxmcc3z/DJI_0314.jpg?rlkey=iog5y4ixhwwvskk1siig5cm4u&dl=1',
    'https://www.dropbox.com/scl/fi/11rtci2a7joaqbuv3jzrz/DJI_0414.jpg?rlkey=nfxtjr4bg4r2aapcy953mzk4z&dl=1',
    'https://www.dropbox.com/scl/fi/cvs3k7685pve4a76gtp35/DJI_0439.jpg?rlkey=r00tx1cykkx1nh7493tzmywus&dl=1',
    'https://www.dropbox.com/scl/fi/cqqv396qqqeuokq0rw2cn/DJI_0449.jpg?rlkey=bzp8r7zejpin2to1aj2qk7p7b&dl=1'
]

def download_file(url, save_name):
    url = url
    if not os.path.exists(save_name):
        file = requests.get(url)
        open(save_name, 'wb').write(file.content)
 
for i, url in enumerate(file_urls):
    if 'mp4' in file_urls[i]:
        download_file(
            file_urls[i],
            f"video.mp4"
        )
    else:
        download_file(
            file_urls[i],
            f"image_{i}.jpg"
        )


model = YOLO('plastic.pt')
path  = [['image_0.jpg'], ['image_1.jpg'], ['image_2.jpg'], ['image_3.jpg'], ['image_4.jpg']]

# path = [['IMG_7612.JPG'], ['IMG_7678.JPG'], ['all_33.jpg'], ['all_80.jpg'], 
#     ['DSC02813.JPG'], ['DSC02373.JPG']]


# path  = [['sc_1_0 (1) (1).JPG'], ['sc_1_0 (16) (1).JPG'], 
#         ['sc_1_0 (18) (1).JPG'], ['sc_1_0 (18).JPG']]

# video_path = [['video.mp4']]

classes = ['plastic-waste']

def show_preds_image(image_path):
    image = cv2.imread(image_path)
    outputs = model.predict(source=image_path, agnostic_nms=True, conf=0.25, iou=0.4, imgsz=1024)
    results = outputs[0].cpu().numpy()

    re_boxes = results.boxes.data.tolist()

    class_color = (95, 255, 54)
    random.seed(42)
    # class_colors = [(random.randint(0, 255), random.randint(0, 255), random.randint(0, 255)) for _ in range(4)]

    for i, det in enumerate(results.boxes.xyxy):
        x1, y1, x2, y2 = int(det[0]),  int(det[1]),  int(det[2]),  int(det[3])

        class_label = int(re_boxes[i][-1])
        # rectangle_color = class_colors[class_label]
        text_color = class_color
        cv2.rectangle(
            image,
            (int(det[0]), int(det[1])),
            (int(det[2]), int(det[3])),
            color=class_color,
            thickness=3,
            lineType=cv2.LINE_AA
        )

        text_position = (x1, y1+100)
        conf = re_boxes[i][-2]
        class_name = classes[class_label]
        # class_label = class_name.split('_')[0] + '\n' + class_name.split('_')[1] if '_' in class_name else class_name
        cv2.putText(image, classes[class_label] + f' = {round(conf, 2)}',
            text_position, cv2.FONT_HERSHEY_SIMPLEX, 1.5, text_color, 3)
        

    return cv2.cvtColor(image, cv2.COLOR_BGR2RGB)
 
inputs_image = [
    gr.components.Image(type="filepath", label="Input Image"),
]
outputs_image = [
    gr.components.Image(type="numpy", label="Output Image")
]

interface_image = gr.Interface(
    fn=show_preds_image,
    inputs=inputs_image,
    outputs=outputs_image,
    title="Plastic Waste Detector in Sagion Rivers.",
    examples=path,
    cache_examples=False,
        description= 'This is Computer Vision App that takes in images  and \
            \n detects plastic waste in rivers. This was deployed after I participated \
            \n in a hackathon organized by Reva University.' 

    )

interface_image.queue().launch()