import openai
import os
import gradio as gr

openai.api_key = os.environ.get("OPENAI_API_KEY")
openai.api_base = "https://api.fe8.cn/v1"

def generate_text(prefix: str, suffix: str) -> str:
    response = openai.Completion.create(
        model="text-davinci-003",
        prompt=prefix,
        suffix=suffix,
        max_tokens=1024,
    )
    return response["choices"][0]["text"]

# 定义Gradio接口
iface = gr.Interface(
    fn=generate_text,
    inputs=[gr.Textbox(lines=10, label="Prefix"), 
            gr.Textbox(lines=10, label="Suffix")],
    outputs=gr.Textbox(),
)

# 启动Gradio接口
iface.launch()
