import gradio as gr
from fastai.vision.all import *
import skimage

learn = load_learner('catloaf.pkl')

labels = learn.dls.vocab
def predict(img):
    img = PILImage.create(img)
    pred,pred_idx,probs = learn.predict(img)
    return {labels[i]: float(probs[i]) for i in range(len(labels))}

title = "Cat or Bread Loaf?"
description = "A loaf classifier"
examples = ['cat-loaf.jpg', 'bread-loaf.jpg']
interpretation='default'
enable_queue=True

gr.Interface(fn=predict,inputs=gr.inputs.Image(shape=(512, 512)),outputs=gr.outputs.Label(num_top_classes=2),title=title,description=description,examples=examples,interpretation=interpretation,enable_queue=enable_queue).launch()