import gradio as gr
from transformers import pipeline

sentiment = pipeline("sentiment-analysis")

def get_sentiment(input_text):
  return sentiment(input_text)

if __name__ == "__main__":
  iface = gr.Interface(
    fn = get_sentiment, 
    inputs = "text", 
    outputs = ['text'],
    title = 'Sentiment Analysis', 
    description = 'Determine how negative or positive a given sentiment is. Input a sentence or two and see what the model "thinks."',
    btn = gr.Button("Run"),
    css="app.css",
    examples=[
        ["better than nothing, I guess... I guess you get what you pay for :("],
        ["This is better than nothing. You get what you pay for!"],
        ["the price reasonable"],
        ["Is this price considered reasonable?"],
        ["This is better than a kick in the face. Guess you can't look a gift horse in the mouth."],
        ["They seem to have a bias as all the people working at the reception look exactly the same."],
        ["All the people working at the reception look exactly the same!"],
        ["this was expected, clean towels and room cleaned every day"],
        ["The top of the window was covered by a dirty blind. It was pretty gross."],
        ["The helpful staff were consistently cheap and comfortable."]
    ]
  )
  iface.launch(inline = False)