from torchvision.models import MobileNet_V2_Weights, mobilenet_v2
from torch import nn 


def create_mobilenet_model(class_num=5, return_transforms = False):
    weights = MobileNet_V2_Weights.DEFAULT
    model = mobilenet_v2(weights=weights)

    for param in model.features.parameters():
        param.requires_grad = False

    in_features = model.classifier[-1].in_features
    model.classifier[-1] = nn.Linear(in_features, class_num)

    if return_transforms:
        return model, weights.transforms()
    return model