import torch
import gradio as gr
from model import create_mobilenet_model
from torchvision import transforms
from timeit import default_timer as timer


class_names = ['Earring', 'Bracelet', 'Pendant', 'Ring', 'Necklace']

test_transforms = transforms.Compose([
    transforms.Resize((224, 224)),
    transforms.ToTensor(),
    transforms.Normalize(
        mean=[0.485, 0.456, 0.406],
        std=[0.229, 0.224, 0.225]
    )
])

model = create_mobilenet_model()
model.load_state_dict(torch.load("mobilenet_epochs_20.pth", map_location=torch.device('cpu')))

def pred(img):
    start = timer()
    img = test_transforms(img).unsqueeze(0)

    model.eval()
    with torch.inference_mode():
        y_pred = torch.softmax(model(img), dim=1)

    pred_probs = {class_names[i]: float(y_pred[0][i]) for i in range(len(class_names))}
    pred_time = round(timer() - start, 5)

    return pred_probs, pred_time 


demo = gr.Interface(fn=pred, 
            inputs=gr.Image(size=(224, 224), type="pil"), 
            outputs=[gr.Label(num_top_classes=3, label="Prediction"),
                     gr.Number(label="Prediction Time")],
            title="JewelryVision")

demo.launch()