import os
import gradio as gr
from steamship import Steamship

#if you have OpenAI API key as an environment variable, enable the below
#openai.api_key = os.getenv("OPENAI_API_KEY")

#if you have OpenAI API key as a string, enable the below

client = Steamship(workspace="gpt-411111111")
generator = client.use_plugin('gpt-4')

prompt = "你好，我是做客ChatBot，当前运行在OpenAI GPT-4模型，欢迎大家通过我体验GPT-4的强大。"


def openai_create(prompt):
  task = generator.generate(text=prompt)
  task.wait()
  return task.output.blocks[0].text


def chatgpt_clone(input, history):
  history = history or []
  s = list(sum(history, ()))
  s.append(input)
  inp = ' '.join(s)
  output = openai_create(input)
  output = output.replace("\n", "<br>")
  history.append((input, output))
  return history, history


block = gr.Blocks()

with block:
  gr.Markdown("""<img src="file/ZookChatBot.png">""")
  chatbot = gr.Chatbot()
  message = gr.Textbox(placeholder=prompt, label="开聊：")
  state = gr.State()
  submit = gr.Button("提交")
  submit.click(chatgpt_clone,
               inputs=[message, state],
               outputs=[chatbot, state])

block.launch(debug=True)