#|export
from fastai.vision.all import *
import gradio as gr

#|export
learn = load_learner('beartector.pkl')

#|export
categories = ('Black Bear', 'Grizzly Bear', 'Koala Bear',  'Panda Bear', 'Polar Bear', 'Teddy Bear')
def classify_image(img):
  pred,idx,probs = learn.predict(img)
  return dict(zip(categories, map(float,probs)))

#|export
image = gr.inputs.Image(shape=(192,192))
label = gr.outputs.Label()

intf = gr.Interface(fn=classify_image, inputs=image, outputs = label)
intf.launch(inline=False)