import gradio as gr
import openai
from pathlib import Path
import requests
import json
from huggingface_hub import login
from datasets import load_dataset, Dataset
import os
from datetime import date
from PIL import Image
from io import BytesIO
import random
import html2text
import re
from markdown import markdown

myopenaikey = os.getenv('openaiapi')
openai.api_key = myopenaikey
os.environ["OPENAI_API_KEY"] = myopenaikey
login(os.environ.get("HF_TOKEN"))

API_URL_LLAMA2 = "https://api-inference.huggingface.co/models/meta-llama/Llama-2-7b-chat-hf"
headers_llama2 = {"Authorization": "Bearer "+ os.environ.get("Vincenzo_key") }


def scrape_page_content(my_company, my_company_url, my_company_page):

    desc = get_company_info(my_company_url)
    if len(desc) >= 500:
        prompt = "Could you summarize the following Company description in 2-3 sentences: {}".format(desc)
        output = openai.Completion.create(
            model="gpt-3.5-turbo-instruct",
            prompt=prompt,
            max_tokens=100,
            )

        desc = output.choices[0].text

    try:
        response = requests.get(my_company_page)
        response.raise_for_status()
        html_conv = html2text.HTML2Text()
        html_conv.ignore_links = True
        html_conv.escape_all = True
        content = html_conv.handle(response.text)

        ratio1 = 0.1
        ratio2 = 0.1
        for i in range(0,10):
            if len(content[round(len(content) * ratio1): len(content) - round(len(content) * ratio2)]) < 10000:
              break
            
            if i%2 == 0:
              ratio1 = ratio1 + 0.1
            else:
              ratio2 = ratio2 + 0.1

        content = content[round(len(content) * ratio1): len(content) - round(len(content) * ratio2)]

        prompt = "Could you summarize the following scraped content from the webpage and write the company value proposition?\n\n{}".format(content)
        
        completion = openai.ChatCompletion.create(
          model="gpt-3.5-turbo",
          messages=[
            {"role": "system", "content": "You are a helpful assistant. Given the context, provide answers to the questions."},
            {"role": "user", "content": prompt}
          ],
          max_tokens=250
        )

        return desc, completion.choices[0].message['content']

    except Exception as e:
        return desc, f"Error while scraping content: {e}"

        
def get_unsplash_images(keywords):

    url = "https://api.unsplash.com/search/photos"

    params = {
        "query": keywords,
        "client_id": os.environ.get("unsplash"),
        "page": 1,
        "per_page": 6
    }

    response = requests.get(url, params=params)

    if response.status_code == 200:
        data = response.json()

        image_urls = [photo["urls"]["regular"] for photo in data["results"]]


        image_contents = []
        for x in image_urls:
            response_2 = requests.get(x)
            image_contents.append(Image.open(BytesIO(response_2.content)))

        return image_contents
    else:
        return None

        
def extract_linkedIn_profile(link):
    api_endpoint = 'https://nubela.co/proxycurl/api/v2/linkedin'
    api_key = os.environ.get("proxyapi")
    header_dic = {'Authorization': 'Bearer ' + api_key}
    params = {
        'url': link,
        'fallback_to_cache': 'on-error',
        'use_cache': 'if-present',
        'skills': 'include',
        'inferred_salary': 'include',
        'personal_email': 'include',
        'personal_contact_number': 'include',
        'twitter_profile_id': 'include',
        'facebook_profile_id': 'include',
        'github_profile_id': 'include',
        'extra': 'include',
    }
    response = requests.get(api_endpoint, params=params, headers=header_dic)

    return response


def get_linkedin_profile(user):
    result =  '''full_name: {}\noccupation: {}\nheadline: {}\nsummary: {}\ncountry: {}\ncity: {}\nlanguages: {}\ngender: {}\nbirth_date: {}\nindustry: {}\ninterests: {}\nskills: {}\n'''.format(user['full_name'], user['occupation'], user['headline'], user['summary'], user['country'], user['city'], ', '.join(user['languages']), user['gender'], user['birth_date'], user['industry'], ', '.join(user['interests']), ', '.join(user['skills']))

    if user['experiences']:
        result += '''experiences:\n'''
        for i,x in enumerate(user['experiences']):
            if i == 0:
                mycompany = x['company']

            if x["ends_at"] is None:
                ends_at = 'None'
            else:
                ends_at = 'Date'
            result += '''company: {}\ntitle: {}\ndescription: {}\nlocation: {}\n'''.format(x['company'], x['title'], x['description'], x['location'], x['company_linkedin_profile_url'], ends_at)

    if user['education']:
        result += '''education:\n'''
        for x in user['education']:
            result += '''field_of_study: {}\ndegree_name: {}\nschool: {}\n'''.format(x['field_of_study'], x['degree_name'], x['school'])


    companies = []
    for x in user['experiences']:
        if x["ends_at"] is None:
            companies.append((x['title'], x['company'], x['company_linkedin_profile_url']))


    return result, user['full_name'], companies


def get_linkedin_profile_summary(link):

    dataset = load_dataset("JayKen/YSF-linkedIn", split="train")

    if link in dataset['users']:
        pos = dataset['users'].index(link)
        user_data = json.loads(dataset['info'][pos])
        user, name, companies = get_linkedin_profile(user_data)

    else:
        response = extract_linkedIn_profile(link)
        user, name, companies = get_linkedin_profile(response.json())

        json_string = json.dumps(response.json())

        dataset = Dataset.from_dict({'users': dataset['users']+[link],
                                    'info': dataset['info']+[json_string]})

        dataset.push_to_hub("JayKen/YSF-linkedIn")

    if len(user) >= 5000:
        user = user.split('experiences')[0]

    prompt = 'The following is LinkedIn profile of a person: {}.\n\n\nCould you highlight most important personality traits of this person in points. List each trait and then further elaborate why you choose it?'.format(user)

    result = openai.Completion.create(engine="text-davinci-003", prompt=prompt, max_tokens=400)

    return name, companies, result.choices[0].text


def get_aud_profile(link):

    global AUD_PRO_SUM
    global AUD_NAME
    global AUD_companies

    AUD_NAME, AUD_companies, AUD_PRO_SUM = get_linkedin_profile_summary(link)

    job_titles = []
    for x in AUD_companies:
      job_titles.append(x[0]+', '+x[1])

    return '\n'.join(job_titles), AUD_PRO_SUM, ''


def set_audience_occ(occupation, company_url):
    global AUD_OCC
    global AUD_COM

    for x in AUD_companies:
        if x[0]+', '+x[1] == occupation:
            AUD_OCC = x[0]
            AUD_COM = x[1]
            url = x[2]
            break

    if url:
        company_url = url

    if company_url:
        desc = get_company_info(company_url)
        if len(desc) >= 500:
            prompt = "Could you summarize the following Company description in 2-3 sentences: {}".format(desc)
            output = openai.Completion.create(
                model="gpt-3.5-turbo-instruct",
                prompt=prompt,
                max_tokens=100,
                )

            desc = output.choices[0].text
    else:
        desc = "Unable to fetch company description. Please enter the company linkedIn url."
        company_url = ''

    return AUD_OCC + '\n' + AUD_COM + '\n' + company_url, desc


def get_company_info(link):

    dataset = load_dataset("JayKen/ysf-company-profile", split="train")

    if link in dataset['url']:
        pos = dataset['url'].index(link)
        company_info = dataset['aboutus'][pos]
    else:
        headers = {'Authorization': 'Bearer ' + os.environ.get("proxyapi")}
        api_endpoint = 'https://nubela.co/proxycurl/api/linkedin/company'
        params = {
            'url': link,
        }
        response = requests.get(api_endpoint,
                                params=params,
                                headers=headers)

        company_info = response.json()['description']

        dataset = Dataset.from_dict({'url': dataset['url']+[link],
                              'aboutus': dataset['aboutus']+[company_info]})

        dataset.push_to_hub("JayKen/ysf-company-profile")

    return company_info



def set_language(language):
    global LANG

    if language == "English (default)":
      LANG = ''
    else:
      LANG = language


def get_subject(brief, cta, relation, language):

    set_language(language)

    prompt = "Here is the brief about my meeting: {}".format(brief)
    prompt += "\nAfter the meeting I want my {} to: {}".format(relation, cta)
    prompt += "\nCombine this and rewrite it for me. \n\nI will combine and rewrite the brief for you: "

    global CTA
    CTA = cta

    completion = openai.ChatCompletion.create(
      model="gpt-3.5-turbo",
      messages=[
        {"role": "system", "content": "You are a helpful assistant. Given the context, provide answers to the questions."},
        {"role": "user", "content": prompt}
      ],
      max_tokens=225
    )

    global SUBJECT
    SUBJECT = completion.choices[0].message['content']

    if len(LANG):

        output = openai.Completion.create(
            model="gpt-3.5-turbo-instruct",
            prompt="Translate the following English text to " + LANG + ": \n\n" + SUBJECT,
            max_tokens=225,
            )

        translation = output.choices[0].text
    else:
        translation = ''

    return prompt, SUBJECT, translation


def get_concern(my_company, my_company_desc, relation, company_desc):

    prompt = "I will have a high-stake conversation with {}. {}. \n\nI work for {}. {}.\n\nI will have a presentation with {} from {} who has the following personality: {}\n\nThe presentation subject is: {}.\n\nWhat could be my {}'s, {} and {} concerns regarding only to {}.\n\nGive me 5-10 points".format(AUD_COM, company_desc, my_company, my_company_desc, AUD_NAME, AUD_COM, AUD_PRO_SUM, SUBJECT, relation, AUD_COM, AUD_NAME, CTA)

    completion = openai.ChatCompletion.create(
      model="gpt-4",
      messages=[
        {"role": "system", "content": "You are a helpful assistant. Given the context, provide answers to the questions."},
        {"role": "user", "content": prompt}
      ],
      max_tokens=500
    )

    return prompt, completion.choices[0].message['content']


def get_concern_step1(my_company, my_company_desc, relation, company_desc):

    prompt = "I will have a high-stake conversation with {}. {}. \n\nI work for {}. {}.\n\nThe presentation subject is: {}.\n\nWhat could be {}'s concerns regarding only to {}.\n\nGive me 5-10 points".format(AUD_COM, company_desc, my_company, my_company_desc, SUBJECT, AUD_COM, CTA)

    completion = openai.ChatCompletion.create(
      model="gpt-3.5-turbo",
      messages=[
        {"role": "system", "content": "You are a helpful assistant. Given the context, provide answers to the questions."},
        {"role": "user", "content": prompt}
      ],
      max_tokens=500
    )

    global CONCERNS1
    CONCERNS1 = prompt + completion.choices[0].message['content']

    return prompt, completion.choices[0].message['content']


def get_concern_step2(relation):
    
    prompt = "I will have a high-stake conversation with {}, {}, who has the following personality: {}.\n\nFrom the above list of concerns show me only the list of concerns that are relevant to {}. ".format(AUD_NAME, relation, AUD_PRO_SUM, AUD_NAME)

    completion = openai.ChatCompletion.create(
      model="gpt-3.5-turbo",
      messages=[
        {"role": "system", "content": CONCERNS1},
        {"role": "user", "content": prompt}
      ],
      max_tokens=500
    )

    if len(LANG):

        output = openai.Completion.create(
            model="gpt-3.5-turbo-instruct",
            prompt="Translate the following English text to " + LANG + ": \n\n" + completion.choices[0].message['content'],
            max_tokens=500,
            )

        translation = output.choices[0].text
    else:
        translation = ''

    return prompt, completion.choices[0].message['content'], translation


def get_andrew(relation, select_concern):

    prompt = "The main presentation subject I want to deliver to my {} is about {}. My {} is {}, who has the following personality: {}\n\nGive me a list of emotional rewards for {} when addressing {}. Focus on the emotional side. Consider {}'s main concerns:\n\n{}\nSort them from the most relevant to the least one.".format(relation, SUBJECT, relation, AUD_OCC, AUD_PRO_SUM, AUD_NAME, CTA, AUD_NAME, select_concern)

    completion = openai.ChatCompletion.create(
      model="gpt-4",
      messages=[
        {"role": "system", "content": "You are a helpful assistant. Given the context, provide answers to the questions."},
        {"role": "user", "content": prompt}
      ],
      max_tokens=400
    )

    if len(LANG):

        output = openai.Completion.create(
            model="gpt-3.5-turbo-instruct",
            prompt="Translate the following English text to " + LANG + ": \n\n" + completion.choices[0].message['content'],
            max_tokens=400,
            )

        translation = output.choices[0].text
    else:
        translation = ''

    return prompt, completion.choices[0].message['content'], translation


def get_andrew_two(my_company, value_prop, relation, aud_com_desc):

    prompt = "I work for {} and its value proposition is: {}\n\nI am eager to explore the gains that my {}, {}, who holds the position of {} at {}: {}, can gain in the context of {}\n\nPlease outline the gains.".format(my_company, value_prop, relation, AUD_NAME, AUD_OCC, AUD_COM, aud_com_desc, CTA)
    
    completion = openai.ChatCompletion.create(
      model="gpt-4",
      messages=[
        {"role": "system", "content": "You are a helpful assistant. Given the context, provide answers to the questions."},
        {"role": "user", "content": prompt}
      ],
      max_tokens=400
    )

    if len(LANG):

        output = openai.Completion.create(
            model="gpt-3.5-turbo-instruct",
            prompt="Translate the following English text to " + LANG + ": \n\n" + completion.choices[0].message['content'],
            max_tokens=400,
            )

        translation = output.choices[0].text
    else:
        translation = ''

    return prompt, completion.choices[0].message['content'], translation


def get_andrew_three(relation, s1, s2):

    prompt = "I am in the process of engaging my {} who holds the position of {}, to take concrete actions aligned with the presented topic: {}. I would greatly appreciate your expertise in crafting three distinct and compelling narratives that I can keep in mind when meeting my {}- {}, during a meeting. Each narrative must consider all the following points in the same narrative:\n\n1) {}.\n\n2) {}.\n\nKeep each narrative to 3-5 sentences. Don't address the audience. Use the following format Narrative 1: [write narrative]\nNarrative 2: [write narrative]\nNarrative 3: [write narrative].".format(relation, AUD_OCC, SUBJECT, relation, AUD_NAME, s1, s2)

    completion = openai.ChatCompletion.create(
      model="gpt-3.5-turbo",
      messages=[
        {"role": "system", "content": "You are a helpful assistant. Given the context, provide answers to the questions."},
        {"role": "user", "content": prompt}
      ],
      max_tokens=400
    )

    if len(LANG):

        output = openai.Completion.create(
            model="gpt-3.5-turbo-instruct",
            prompt="Translate the following English text to " + LANG + ": \n\n" + completion.choices[0].message['content'],
            max_tokens=400,
            )

        translation = output.choices[0].text
    else:
        translation = ''

    return prompt, completion.choices[0].message['content'], translation


def create_slides2(narrative, concerns, wins, gains):

    combined_prompt = "Can you create a business PPT presentation following the Hero Journey steps:\n\nOrdinary World: Describe the customer's current situation or pain point.\nCall to Adventure: Introduce the possibility of a solution (your product/service).\nRefusal of the Call: Address common objections or misconceptions.\nMeeting with the Mentor: Position your company as the guide.\nCrossing the First Threshold: Highlight first stepsto engage with your solution.\nTests, Allies, Enemies: Discuss case studies, user stories, and support.\nApproach to the Inmost Cave: Dive into the features and benefits.\nOrdeal: Address main objections and how your solution tackles them.\nReward: Emphasize the value and benefits of your solution.\nThe Road Back: Guide on the next steps or integration.\nResurrection: Reiterate the transformation promised.\nReturn with the Elixir: Call to action.\n\nMy storyline is:{}\n\nSome background information is: {}\n\n{}'s concerns are: {}\n\n{}'s emotional rewards are: {}\n\n{}'s gains are: {}\n\nGenerate all 12 steps with 12 slides. Don't use presentation jargons. Keep the bullet points as succinct phrases. Use the following format when generating slides:\nTitle: <An action title for each slide>\n<3-5 bullet points>\nExplanation: <explain each slide so I understand what to say>\n".format(narrative, SUBJECT, AUD_NAME, concerns, AUD_NAME, wins, AUD_NAME, gains)

    completion = openai.ChatCompletion.create(
      model="gpt-4",
      messages=[
        {"role": "system", "content": "You are a helpful assistant. Given the context, provide answers to the questions."},
        {"role": "user", "content": combined_prompt}
      ],
      max_tokens=2500
    )

    return combined_prompt, completion.choices[0].message['content']


def get_profile_element(relation):

    prompt = "I have a meeting with my {} to deliver my presenation on/about : {}.".format(relation, SUBJECT)

    prompt += "His/her personality is: {}.\n\nBased on my presentation subject, what are the two most important elements in his/her personality for me to know/consider? Give me one point in 1-2 sentences max.".format(AUD_LINKEDIN_PROFILE)

    output = openai.Completion.create(
        model="gpt-3.5-turbo-instruct",
        prompt=prompt,
        max_tokens=150,
        )

    return prompt, output.choices[0].text



demo = gr.Blocks()

with demo:
    gr.Markdown("# Your YSF 😄 Personal Coach! Version 1.3")
    with gr.Tabs():
        with gr.TabItem("Presentation Subject"):
            with gr.Row():
                with gr.Column():
                    my_company = gr.Textbox(label="My Company Name")
                    my_company_url = gr.Textbox(label="My Company linkedIn url")
                    my_company_page = gr.Textbox(label="My company page url")
                    with gr.Row():
                      with gr.Column():
                        button_my_company = gr.Button("Submit", variant="primary")
                with gr.Column():
                    output_my_company_desc = gr.components.Textbox(label="My Company description summarised")
                    output_my_company_value = gr.components.Textbox(label="My Company Value proposition")

            gr.Markdown("## Examples")
            gr.Examples(
                [["Your Speech Factory", "https://www.linkedin.com/company/yourspeechfactory/", "https://www.yourspeechfactory.com/"],
                 ["Dell Technologies", "https://www.linkedin.com/company/delltechnologies/", "https://www.dell.com/en-us/dt/storage/powerflex.htm#tab0=0"]],
                [my_company, my_company_url, my_company_page],
                [output_my_company_desc, output_my_company_value],
                scrape_page_content,
                cache_examples=True,
            )

            with gr.Row():
                with gr.Column():
                    language = gr.Dropdown(["English (default)", "Swedish", "Norwegian", "Italian"], label="Select Translation language")
                    input_relation = gr.Textbox(label="Your relationship with audience your presenting to")
                    input_brief = gr.Textbox(label="Brief me on the situation and/or meeting focus")
                    input_cta = gr.Textbox(label="Call to action")
                    with gr.Row():
                      with gr.Column():
                        button_subject = gr.Button("Submit", variant="primary")
                with gr.Column():
                    output_subject_prompt = gr.components.Textbox(label="Input prompt")
                    output_subject = gr.components.Textbox(label="Output presentation subject")
                    output_subject_translate = gr.components.Textbox(label="Translation")

            gr.Markdown("## Examples")
            gr.Examples(
                [["I'm presenting Your Speech Factory as a business case for a potential equity investment", "Make an equity investment of 200 000 EUR in our upcoming fundraising round", "potential investor", "English (default)"],
                 ["I will have sales meeting to discuss datacenter strategy with BNY Investment", "agree to a demo running Powerflex in AWS", "Client", "English (default)"]],
                [input_brief, input_cta, input_relation, language],
                [output_subject_prompt, output_subject, output_subject_translate],
                get_subject,
                cache_examples=True,
            )


        with gr.TabItem("Set Audience"):
            with gr.Row():
                with gr.Column():
                    input_audience_linkedin_url = gr.Textbox(label="Audience LinkedIn URL")
                    with gr.Row():
                      with gr.Column():
                        button_audience_linkedin_url = gr.Button("Get Profile Summary", variant="primary")
                with gr.Column():
                    output_audience_role = gr.components.Textbox(label="Audience Job titles")
                    output_audience_summary = gr.components.Textbox(label="Audience Profile summary")
                    output_bullets_translate = gr.components.Textbox(label="Translation")

            gr.Markdown("## Examples")
            gr.Examples(
                [["https://www.linkedin.com/in/helge-onsum-47704919/"], ["https://www.linkedin.com/in/sean-traverse-0394a714/"]],
                [input_audience_linkedin_url],
                [output_audience_role, output_audience_summary, output_bullets_translate],
                get_aud_profile,
                cache_examples=True,
            )

            with gr.Row():
                with gr.Column():
                    input_audience_occ = gr.Textbox(label="Select Audience Occupation")
                    aud_company_url = gr.Textbox(label="Enter Company LinkedIn url (optional)")
                    with gr.Row():
                      with gr.Column():
                        button_audience_occ = gr.Button("Set Audience Occupation", variant="primary")
                with gr.Column():
                    output_audience_occ = gr.components.Textbox(label="Job Title Set")
                    output_company_desc = gr.components.Textbox(label="Audience Company description summarised")


        with gr.TabItem("Concerns"):
            with gr.Row():
                with gr.Column():
                    with gr.Row():
                      with gr.Column():
                        button_concern = gr.Button("Generate concerns", variant="primary")
                with gr.Column():
                    output_concern_prompt = gr.components.Textbox(label="Input Prompt")
                    output_concern = gr.components.Textbox(label="Output")


        with gr.TabItem("2 Step Concerns"):
            with gr.Row():
                with gr.Column():
                    with gr.Row():
                      with gr.Column():
                        button_concern_step1 = gr.Button("Generate concerns step 1", variant="primary")
                with gr.Column():
                    output_concern_step1_prompt = gr.components.Textbox(label="Input Prompt")
                    output_concern_step1 = gr.components.Textbox(label="Output")
            with gr.Row():
                with gr.Column():
                    with gr.Row():
                      with gr.Column():
                        button_concern_step2 = gr.Button("Generate concerns step 2", variant="primary")
                with gr.Column():
                    output_concern_step2_prompt = gr.components.Textbox(label="Input Prompt")
                    output_concern_step2 = gr.components.Textbox(label="Output")
                    output_concern_step2_translate = gr.components.Textbox(label="Translation")


        with gr.TabItem("Personal Win"):
            with gr.Row():
                with gr.Column():
                    input_concerns_two = gr.Textbox(label="Selected Concerns")
                    with gr.Row():
                      with gr.Column():
                        button_andrew = gr.Button("Generate rewards", variant="primary")
                with gr.Column():
                    output_andrew_prompt = gr.components.Textbox(label="Input Prompt")
                    output_andrew = gr.components.Textbox(label="Your Output")
                    output_wins_translate = gr.components.Textbox(label="Translation")


        with gr.TabItem("Gains"):
            with gr.Row():
                with gr.Column():
                    input_value_prop = gr.Textbox(label="Enter your company value proposition")
                    with gr.Row():
                      with gr.Column():
                        button_andrew_two = gr.Button("Generate gains", variant="primary")
                with gr.Column():
                    output_andrew_prompt_two = gr.components.Textbox(label="Input Prompt")
                    output_andrew_two = gr.components.Textbox(label="Your Output")
                    output_gains_translate = gr.components.Textbox(label="Translation")

        with gr.TabItem("Narrative"):
            with gr.Row():
                with gr.Column():
                    input_one_three = gr.Textbox(label="Personal Wins")
                    input_two_three = gr.Textbox(label="Gains")
                    with gr.Row():
                      with gr.Column():
                        button_andrew_three = gr.Button("Generate Narratives", variant="primary")
                with gr.Column():
                    output_andrew_prompt_three = gr.components.Textbox(label="Input Prompt")
                    output_andrew_three = gr.components.Textbox(label="Output Narrative")
                    output_narrative_translate = gr.components.Textbox(label="Translation")


        with gr.TabItem("Slides"):
            with gr.Row():
                with gr.Column():
                    input_narrative = gr.Textbox(label="Input Narrative")
                    with gr.Row():
                      with gr.Column():
                        button_slides_concerns = gr.Button("Generate slides", variant="primary")
                with gr.Column():
                    output_slides_prompt = gr.components.Textbox(label="Input prompt")
                    output_slides = gr.components.Textbox(label="Output presentation slides")

            with gr.Row():
                with gr.Column():
                    input_keyword = gr.Textbox(lines=1, label="Input Keywords")
                    with gr.Row():
                      with gr.Column():
                        button_unsplash = gr.Button("Generate Slide Images", variant="primary")
                with gr.Column():
                    output_unsplash = gr.Gallery(label="Found relevant Images", show_label=False,
                                                 elem_id="gallery", columns=[2], rows=[2], object_fit="contain", height="auto")


        with gr.TabItem("Personality element"):
            with gr.Row():
                with gr.Column():
                    with gr.Row():
                      with gr.Column():
                        button_element = gr.Button("Extract personality", variant="primary")
                with gr.Column():
                    output_element_prompt = gr.components.Textbox(label="Input Prompt")
                    output_element = gr.components.Textbox(label="Most Important personality highlight")



    button_my_company.click(scrape_page_content, inputs=[my_company, my_company_url, my_company_page],
                            outputs=[output_my_company_desc, output_my_company_value])

    button_subject.click(get_subject, inputs=[input_brief, input_cta, input_relation, language],
                         outputs=[output_subject_prompt, output_subject, output_subject_translate])

    button_audience_linkedin_url.click(get_aud_profile, inputs=[input_audience_linkedin_url],
                                       outputs=[output_audience_role, output_audience_summary, output_bullets_translate])

    button_audience_occ.click(set_audience_occ, inputs=[input_audience_occ, aud_company_url], 
                              outputs=[output_audience_occ, output_company_desc])

    button_concern.click(get_concern, inputs=[my_company, output_my_company_desc, input_relation, output_company_desc],
                               outputs=[output_concern_prompt, output_concern])

    button_concern_step1.click(get_concern_step1, inputs=[my_company, output_my_company_desc, input_relation, output_company_desc],
                               outputs=[output_concern_step1_prompt, output_concern_step1])

    button_concern_step2.click(get_concern_step2, inputs=[input_relation],
                               outputs=[output_concern_step2_prompt, output_concern_step2, output_concern_step2_translate])

    button_andrew.click(get_andrew, inputs=[input_relation, input_concerns_two],
                        outputs=[output_andrew_prompt, output_andrew, output_wins_translate])

    button_andrew_two.click(get_andrew_two, inputs=[my_company, input_value_prop, input_relation, output_company_desc],
                            outputs=[output_andrew_prompt_two, output_andrew_two, output_gains_translate])

    button_andrew_three.click(get_andrew_three, inputs=[input_relation, input_one_three, input_two_three],
                              outputs=[output_andrew_prompt_three, output_andrew_three, output_narrative_translate])

    button_slides_concerns.click(create_slides2, inputs=[input_narrative, input_concerns_two, input_one_three, input_two_three],
                                 outputs=[output_slides_prompt, output_slides])

    button_unsplash.click(get_unsplash_images, inputs=[input_keyword], outputs=[output_unsplash])

    button_element.click(get_profile_element, inputs=[input_relation], outputs=[output_element_prompt, output_element])

demo.launch()