import cv2
import numpy as np
import gradio as gr
import tensorflow as tf
from tensorflow import keras
from tensorflow.keras import layers
from tensorflow.python.keras.layers import Dense, Flatten
from tensorflow.keras.models import Sequential


resnet_model = Sequential()
pretrained_model= tf.keras.applications.ResNet50(include_top=False,
                   input_shape=(224,224,3),
                   pooling='avg',classes=2,
                   weights=None)
for layer in pretrained_model.layers:
        layer.trainable=False

resnet_model.add(pretrained_model)
resnet_model.add(Flatten())
resnet_model.add(Dense(512, activation='relu'))
resnet_model.add(Dense(2, activation='sigmoid'))

resnet_model.load_weights('Train_ResNet50.h5')
class_names = ['No Crack Detected', 'Crack Detected']

def inference(input_image):
  # image=cv2.imread(input_image)
  image_resized= cv2.resize(input_image, (224,224))
  img=np.expand_dims(image_resized,axis=0)
  pred = resnet_model.predict(img)
  output_class = class_names[np.argmax(pred)]
  return output_class
#hehe

image_input = gr.Image()
demo = gr.Interface(fn=inference, inputs=image_input, outputs="label")
demo.launch() 