import openai
import gradio as gr
import datetime

initial_prompt = "List the following in a HTML table with an appropriate number of rows in an appropriate order, giving the table an appropriate caption. Each non-numeric cell in the table, regardless of column, contains a link whenever possible to an appropriate Wikipedia page that opens in a new tab. No other links besides Wikipedia pages are permitted. The table contains around 5 columns with appropriate attributes: "


def set_openai_api_key(api_key, openai_api_key):
    if api_key:
        openai_api_key = api_key
        return openai_api_key


def openai_create(prompt, openai_api_key, temperature):
    print("\n==== date/time: " + str(datetime.datetime.now()) + " ====")
    print("prompt: " + prompt)
    print("temperature: ", temperature)

    openai.api_key = openai_api_key
    response = openai.Completion.create(
        model="text-davinci-003",
        prompt=prompt,
        temperature=temperature,
        max_tokens=2000,
        top_p=1,
        frequency_penalty=0,
        presence_penalty=0
    )
    return response.choices[0].text


def desc2sheet(desc, openai_api_key, temperature):
    if not openai_api_key or openai_api_key == "":
        return "<pre>Please paste your OpenAI API key (see https://beta.openai.com)</pre>"

    html = openai_create(initial_prompt + desc + '\n', openai_api_key, temperature)
    return html


def update_temperature(temp_slider, temp_state):
    if temp_slider:
        temp_state = temp_slider
        return temp_state

block = gr.Blocks(css=".gradio-container {background-color: lightgray}")

with block:
    with gr.Row():
        temperature_slider = gr.Slider(label="GPT Temperature", value=0.0, minimum=0.0, maximum=1.0, step=0.1)
        title = gr.Markdown("""<h3><center>GPT-3.5 Table-inator</center></h3>""")
        openai_api_key_textbox = gr.Textbox(placeholder="Paste your OpenAI API key",
                                            show_label=False, lines=1, type='password')

    table = gr.Markdown("")
    with gr.Row():
        request = gr.Textbox(label="GPT prompt: " + initial_prompt,
                             placeholder="Ex: Computer languages")

        submit = gr.Button(value="Create", variant="secondary").style(full_width=False)

    openai_api_key_state = gr.State()
    temperature_state = gr.State(0.0)

    submit.click(desc2sheet, inputs=[request, openai_api_key_state, temperature_state], outputs=[table])
    request.submit(desc2sheet, inputs=[request, openai_api_key_state, temperature_state], outputs=[table])

    openai_api_key_textbox.change(set_openai_api_key,
                                  inputs=[openai_api_key_textbox, openai_api_key_state],
                                  outputs=[openai_api_key_state])

    temperature_slider.change(update_temperature,
                              inputs=[temperature_slider, temperature_state],
                              outputs=[temperature_state])

block.launch()
