from sklearn.feature_extraction.text import TfidfVectorizer
from sklearn.multioutput import MultiOutputClassifier
from sklearn.ensemble import RandomForestClassifier
from sklearn.model_selection import train_test_split
from sklearn.metrics import accuracy_score, hamming_loss
import numpy as np

# Step 1: Data Preprocessing
# Assuming you have X as your TF-IDF word matrix and y as the corresponding tags

# Splitting the data into training and testing sets
X_train, X_test, y_train, y_test = train_test_split(X, y, test_size=0.2, random_state=42)

# Step 2: Model Selection
# Using RandomForestClassifier as an example
model = MultiOutputClassifier(RandomForestClassifier(n_estimators=100))

# Step 3: Model Training
model.fit(X_train, y_train)

# Step 4: Model Evaluation
y_pred = model.predict(X_test)

# Evaluating performance using accuracy and hamming loss
accuracy = accuracy_score(y_test, y_pred)
hamming_loss = hamming_loss(y_test, y_pred)

print("Accuracy:", accuracy)
print("Hamming Loss:", hamming_loss)

# Step 5: Prediction
# Assuming you have new_data as the new TF-IDF word matrix for prediction
new_data = ...

# Transform the new data using the same TfidfVectorizer
new_data_transformed = tfidf_vectorizer.transform(new_data)

# Predict the tags for new data
new_data_pred = model.predict(new_data_transformed)

# Accessing the predicted tags for each sample
for i, sample in enumerate(new_data):
    predicted_tags = [tag for tag, pred in zip(model.classes_, new_data_pred[i]) if pred == 1]
    print("Sample {}: Predicted Tags: {}".format(i+1, predicted_tags))