import tkinter as tk
import pickle 
import dill
from nltk.tokenize import word_tokenize
import re
from nltk.corpus import stopwords
from nltk.stem.snowball import SnowballStemmer
import numpy as np
import pandas as pd
stop_words = set(stopwords.words('english'))
stemmer = SnowballStemmer("english")

#load model
y_vectorizer = dill.load(open("y_vectorizer_file_180k_50.pkl", "rb"))
vectorizer = dill.load(open("vectorizer_180k_50.pkl", "rb"))
clf = pickle.load(open("fileSVM50.pkl", "rb"))
#xử lí title và body của question

def chuan_hoa_title_va_text(title, body):
    body=re.sub('<code>(.*?)</code>', '', body, flags=re.MULTILINE|re.DOTALL)
    body = re.sub('<.*?>', ' ', str(body.encode('utf-8')))
    title=str(title).encode('utf-8')
    question=str(title)+" "+str(title)+" "+str(title)+" "+ body
    question=re.sub(r'[^A-Za-z]+',' ',question)
    words=word_tokenize(str(question.lower()))
    question=' '.join(str(stemmer.stem(j)) for j in words if j not in stop_words and (len(j)!=1 or j=='c'))
    return question

#chuyển câu hỏi về TF-IDF để dự đoán
question = chuan_hoa_title_va_text(title="C# Can't Process.Start a Python script on Ubuntu with Unity", body="for my project I need to create a TTS voice using a library that only has Python support. I already have a functioning Python script, but for whatever reason when I run my C# script in Unity it just skips right over the code for running the script. I don't get any errors from it, it just doesn't do anything with the script. Here's my current code: Process.Start(@/usr/bin/python3.10, /full/path/to/script.py); It doesn't seem to matter if I enable UseShellExecute or not, or use a ProcessStartInfo with it instead, and same thing with setting the working directory. I also triple checked that my Python script isn't throwing errors.")
df222 = pd.DataFrame({"question": [question]})
sample_tfidf = vectorizer.transform(df222['question'])

sample_pred = clf.predict(sample_tfidf)


'''for Logistic method'''
# sample_pred = clf.predict_proba(sample_tfidf)
# Sắp xếp xác suất theo thứ tự giảm dần
# sorted_indices = np.argsort(sample_pred, axis=1)[:, ::-1]
# # Lấy tên nhãn tương ứng từ mô hình
# labels = y_vectorizer.get_feature_names_out()
# # Lấy tên nhãn theo xác suất đã sắp xếp
# sorted_labels = labels[sorted_indices]






import tkinter as tk

def process_question_with_logistic():
    title = title_entry.get()
    question = question_entry.get()
    question = chuan_hoa_title_va_text(title, question)
    df222 = pd.DataFrame({"question": [question]})
    sample_tfidf = vectorizer.transform(df222['question'])
    
    # Perform some processing on the title and question
    # Replace this with your own processing logic
    
    # Example processing: Concatenate title and question
    sample_pred = clf.predict_proba(sample_tfidf)
    # Sắp xếp xác suất theo thứ tự giảm dần
    sorted_indices = np.argsort(sample_pred, axis=1)[:, ::-1]
    # Lấy tên nhãn tương ứng từ mô hình
    labels = y_vectorizer.get_feature_names_out()
    # Lấy tên nhãn theo xác suất đã sắp xếp
    sorted_labels = labels[sorted_indices]
    output = ""
    for j in range(0, 6):
        print(f"Nhãn: {sorted_labels[0][j]}, Xác suất: {sample_pred[0][sorted_indices[0][j]]}")
        if sorted_labels[0][j] != "selenium-chromedriver":
            output += f"Nhãn: {sorted_labels[0][j]}, Xác suất: {sample_pred[0][sorted_indices[0][j]]}" + "\n"
    
    output_label.config(text=output)

def process_question():
    title = title_entry.get()
    question = question_entry.get()
    print("tieu de cau hoi: ", title)
    print("-----------------------------")
    print("cau hoi", question)
    question = chuan_hoa_title_va_text(title, question)
    print("-----------------------------")
    print("question sau chuan hoa: ", question)
    df222 = pd.DataFrame({"question": [question]})
    sample_tfidf = vectorizer.transform(df222['question'])
    print("-----------------------------")
    print("cau hoi sau khi ma hoa: ", sample_tfidf)
    # Perform some processing on the title and question
    # Replace this with your own processing logic
    
    # Example processing: Concatenate title and question
    sample_pred = clf.predict(sample_tfidf)
    # Sắp xếp xác suất theo thứ tự giảm dần
    # sorted_indices = np.argsort(sample_pred, axis=1)[:, ::-1]
    # Lấy tên nhãn tương ứng từ mô hình
    labels = y_vectorizer.get_feature_names_out()
    # Lấy tên nhãn theo xác suất đã sắp xếp
    # sorted_labels = labels[sorted_indices]
    output = ""
    print(y_vectorizer.inverse_transform(sample_pred))
    # for j in range(len(sample_pred)):
    #     # print(f"Nhãn: {sorted_labels[0][j]}, Xác suất: {sample_pred[0][sorted_indices[0][j]]}")
    #     # if sorted_labels[0][j] != "selenium-chromedriver":
    #         output += f"Nhãn: {y_vectorizer.inverse_transform(sample_pred)}" + "\n"
    
    output_label.config(text=y_vectorizer.inverse_transform(sample_pred))
# Create the main window
window = tk.Tk()
window.title("Simple GUI Example")

# Create the title label and entry field
title_label = tk.Label(window, text="Title:")
title_label.pack()

title_entry = tk.Entry(window)
title_entry.pack()

# Create the question label and entry field
question_label = tk.Label(window, text="Question:")
question_label.pack()

question_entry = tk.Entry(window)
question_entry.pack()

# Create the process button
process_button = tk.Button(window, text="Process", command=process_question)
process_button.pack()

# Create the output label
output_label = tk.Label(window, text="")
output_label.pack()

# Start the main event loop
window.mainloop()