import gradio as gr
import tkinter as tk
import pickle 
import dill
import nltk
nltk.download('stopwords')
nltk.download('punkt')
from nltk.tokenize import word_tokenize
import re
from nltk.corpus import stopwords
from nltk.stem.snowball import SnowballStemmer
import numpy as np
import pandas as pd
stop_words = set(stopwords.words('english'))
stemmer = SnowballStemmer("english")

# Load model
y_vectorizer = dill.load(open("y_vectorizer_file_180k_50.pkl", "rb"))
vectorizer = dill.load(open("vectorizer_180k_50.pkl", "rb"))
clf = pickle.load(open("fileSVM50.pkl", "rb"))

# Xử lí title và body của question
def process_title_and_body(title, body):
    body= re.sub(r'<code(.*?)</code>', '', body, flags=re.MULTILINE|re.DOTALL)
    body = re.sub('<.*?>', ' ', str(body.encode('utf-8')))
    title=str(title).encode('utf-8')
    question=str(title)+" "+str(title)+" "+str(title)+" "+ body
    question=re.sub(r'[^A-Za-z]+',' ',question)
    words=word_tokenize(str(question.lower()))
    question=' '.join(str(stemmer.stem(j)) for j in words if j not in stop_words and (len(j)!=1 or j=='c'))
    return question

def predict_question(title, body):
    # Chuẩn hóa title và body
    question = process_title_and_body(title, body)
    df222 = pd.DataFrame({"question": [question]})
    # Chuyển câu hỏi về dạng vector
    sample_tfidf = vectorizer.transform(df222['question'])
    # Dự đoán
    sample_pred = clf.predict(sample_tfidf)
    # Đưa nhãn từ dạng vector sang dạng text ban đầu
    result = y_vectorizer.inverse_transform(sample_pred)
    list_result = list(result[0])
    exclude_list = ['firebase', 'gitlab', 'office365', 'scikit-learn', 'selenium-webdriver', 'shiny', 'single-sign-on', 'x86-64']
    result_list = [item for item in list_result if item not in exclude_list]
    return result_list

with gr.Blocks() as app:
    gr.Markdown("Mô hình Machine Learning gán nhãn từ động từ tiêu đề và nội dung câu hỏi")
    title = gr.Text(label="Tiêu đề", info="Nhập tiêu đề câu hỏi")
    body = gr.Text(label="Nội dung", info="Nhập nội dung câu hỏi", lines=5)
    btn_submit = gr.Button(size='sm', variant='primary', value="Tạo nhãn")
    result = gr.Text(label="Nhãn")
    btn_submit.click(
        fn=predict_question,
        inputs=[title, body],
        outputs=result
    )
    gr.Markdown("----Examples----")
    gr.Examples(
        [["Unfortunately MyApp has stopped. How can I solve this?", "I am developing an application, and everytime I run it, I get the message:\
            Unfortunately, MyApp has stopped.\
            What can I do to solve this?\
            About this question - obviously inspired by What is a stack trace, and how can I use it to debug my application errors?, there are lots of questions stating that their application has crashed, without any further detail. This question aims to instruct novice Android programmers on how to try and fix their problems themselves, or ask the right questions."]
            ,["How do I parse JSON in Android?", "How do I parse a JSON feed in Android?"]
            ,["How do I return the response from an asynchronous call?",
                "<div class=\"s-prose js-post-body\" itemprop=\"text\"> <p>How do I return the response/result from a function <code>foo</code> that makes an asynchronous request?</p> <p>I am trying to return the value from the callback, as well as assigning the result to a local variable inside the function and returning that one, but none of those ways actually return the response — they all return <code>undefined</code> or whatever the initial value of the variable <code>result</code> is.</p> <p><strong>Example of an asynchronous function that accepts a callback</strong> (using jQuery's <code>ajax</code> function):</p> <pre class=\"lang-js s-code-block\"><code class=\"hljs language-javascript\"><span class=\"hljs-keyword\">function</span> <span class=\"hljs-title function_\">foo</span>(<span class=\"hljs-params\"></span>) { <span class=\"hljs-keyword\">var</span> result; $.<span class=\"hljs-title function_\">ajax</span>({ <span class=\"hljs-attr\">url</span>: <span class=\"hljs-string\">'...'</span>, <span class=\"hljs-attr\">success</span>: <span class=\"hljs-keyword\">function</span>(<span class=\"hljs-params\">response</span>) { result = response; <span class=\"hljs-comment\">// return response; // &lt;- I tried that one as well</span> } }); <span class=\"hljs-keyword\">return</span> result; <span class=\"hljs-comment\">// It always returns `undefined`</span> } </code></pre> <p><strong>Example using Node.js:</strong></p> <pre class=\"lang-js s-code-block\"><code class=\"hljs language-javascript\"><span class=\"hljs-keyword\">function</span> <span class=\"hljs-title function_\">foo</span>(<span class=\"hljs-params\"></span>) { <span class=\"hljs-keyword\">var</span> result; fs.<span class=\"hljs-title function_\">readFile</span>(<span class=\"hljs-string\">\"path/to/file\"</span>, <span class=\"hljs-keyword\">function</span>(<span class=\"hljs-params\">err, data</span>) { result = data; <span class=\"hljs-comment\">// return data; // &lt;- I tried that one as well</span> }); <span class=\"hljs-keyword\">return</span> result; <span class=\"hljs-comment\">// It always returns `undefined`</span> } </code></pre> <p><strong>Example using the <code>then</code> block of a promise:</strong></p> <pre class=\"lang-js s-code-block\"><code class=\"hljs language-javascript\"><span class=\"hljs-keyword\">function</span> <span class=\"hljs-title function_\">foo</span>(<span class=\"hljs-params\"></span>) { <span class=\"hljs-keyword\">var</span> result; <span class=\"hljs-title function_\">fetch</span>(url).<span class=\"hljs-title function_\">then</span>(<span class=\"hljs-keyword\">function</span>(<span class=\"hljs-params\">response</span>) { result = response; <span class=\"hljs-comment\">// return response; // &lt;- I tried that one as well</span> }); <span class=\"hljs-keyword\">return</span> result; <span class=\"hljs-comment\">// It always returns `undefined`</span> } </code></pre> </div>"
            ]
            ],
        [title, body],
    )
app.launch()



