import streamlit as st
import cv2
import json
from deepface import DeepFace
from tensorflow.keras.models import model_from_json
import numpy as np

# Emotion mappings
mappings = {
  'angry': ["Hot coffee - Help them cool down", "Apple slices - Healthy snack", "Bottle of water - Hydration", "Drive-thru only - Get out faster", "Veggie wrap - Lighter option"],
    'sad': ["Hot fudge sundae - Sweet treat", "French fries - Comfort food", "Chicken nuggets - Familiar favorite", "Chili - Hearty and soothing", "Baked apple pie - Nostalgic dessert"],
    'happy': ["McFlurry - Indulgent and celebratory", "Bacon smokehouse burger - Premium and new", "McCafe frappé - Sweet cold drink", "6-piece chicken nuggets - Shareable", "Shake and fries - Tasty combo"],
    'surprise': ["Fun drink specials", "dessert", "New menu items", "Free upsize"],
    'tired': ["Iced coffee - Caffeine boost", "Egg McMuffin - High protein", "Fruit yogurt parfait - Light and energizing", "Oatmeal - Whole grains for lasting energy", "Hash browns - Carbs and salt for fast energy"],
    'neutral': ["Hamburger - Classic choice", "Cheeseburger - Familiar favorite", "Medium fries - Typical go-to", "6-piece nuggets - Satisfying option", "Any drink - Quench their thirst"],
    'fearful': ["Bottled water - Hydration and calm", "Apple slices - Healthy light snack", "Yogurt parfait - Gentle on stomach", "Oatmeal - Warm and comforting", "Salad - Fresh and simple"]
}

@st.cache_resource
def load_model():
    # Load model JSON
    with open('model.json', 'r') as f:
        model = model_from_json(f.read())

    return model


# Set background  
import streamlit as st
from PIL import Image

image = Image.open('shutterstock_download.jpg')

st.image(image)
with st.spinner('Loading Food Recommender...'):
  model = load_model()
# Load the background image
# page_bg="""
# <style>
# [data-testid='stAppViewContainer']{
# background-image:url('https://unsplash.com/photos/yxpJQ83DtOM');
# background-size:cover;
# }
# </style>
# """

# # Set the background image
# st.markdown(page_bg,unsafe_allow_html=True
# )
st.title("Your Food Buddy")

image = st.file_uploader("Upload an image")



if image:
    img = cv2.imdecode(np.fromstring(image.read(), np.uint8), cv2.IMREAD_UNCHANGED) 
    # model = load_model()
    st.image(image, caption='Uploaded Image')
    result = DeepFace.analyze(img, enforce_detection=True)
    dominant = max(result[0]['emotion'], key=result[0]['emotion'].get)
    st.success(f"The person is {dominant}")
    
    st.header("Recommended Menu Items:")
    for item in mappings[dominant]:
        st.write("- " + item)
