import gradio as gr
from fastai.vision.all import *
learn = load_learner("dogIdentifier.pkl")
labels = learn.dls.vocab
def predict(img):
    img = PILImage.create(img)
    pred,pred_idx,probs = learn.predict(img)
    return {labels[i]: float(probs[i]) for i in range(len(labels))}

inter_arguments = {
    "fn": predict, 
    "inputs":gr.inputs.Image(shape=(512, 512)),
    "outputs": gr.outputs.Label(num_top_classes=3),
    "title": "Dog Breed Classifier",
    "description": "It contains the ten main breeds of dogs, including Beagle, Bulldog, Chihuahua, Dachshund, German Sheperd, Golden Retriver, Husky, Malamute and Poodle",
    "interpretation": 'default',
    "examples": ["images/Chihuahua_1.jpg"],
    "article": "<p style='text-align: center'><a href='https://tmabraham.github.io/blog/gradio_hf_spaces_tutorial' target='_blank'>Blog post</a></p>"

    }
gr.Interface(**inter_arguments).launch(share=True)

# import gradio as gr

# def greet(name):
#     return "Hello " + name + "!!"

# iface = gr.Interface(fn=greet, inputs="text", outputs="text")
# iface.launch()