import pytorch_lightning as pl
from transformers import AutoModelForImageClassification, ViTConfig, AutoConfig
import torch

class ImageClassificationModel(pl.LightningModule):
    def __init__(self, HF_MODEL_NAME):
        super().__init__()
        config = AutoConfig.from_pretrained(HF_MODEL_NAME, num_labels=6)
        self.model = AutoModelForImageClassification.from_config(config=config)
        self.model.config = config
        self.model.config.id2label = {
            0: "None",
            1: "Cat",
            2: "Mouse",
            3: "Possum",
            4: "Rat",
            5: "Stoat",
        }
        self.model.config.label2id = {v: k for k, v in self.model.config.id2label.items()}

    def forward(self, x):
        return self.model(x)