from transformers import pipeline
import gradio as grad

zero_shot_cls = pipeline("zero-shot-classification")

def classify(text, labels):
    cls_labels = labels.split(",")

    #["IT", "software", "marketing", "sales", "R&D", "logistics"]
    response = zero_shot_cls(text, cls_labels)
    return response

in_text = grad.Textbox(lines=1, label="English", placeholder="Text to be classified")
in_labels = grad.Textbox(lines=1, label="Labels", placeholder="Comma separated labels")
out = grad.Textbox(lines=1, label="Classification") 

grad.Interface(classify, inputs=[in_text, in_labels], outputs=out).launch()