from transformers import T5ForConditionalGeneration, T5Tokenizer
import gradio as gr

model_name = "t5-small"
text2text_token= T5Tokenizer.from_pretrained(model_name)
model = T5ForConditionalGeneration.from_pretrained(model_name)

def text2text_sentiment(text):
     input = "sst2 sentence: " + text
     encoded = text2text_token(input, return_tensors="pt")
     tokens = model.generate(**encoded)
     response = text2text_token.batch_decode(tokens)
     return response

# UX
in_para = gr.Textbox(lines=1, label="Input text in English", placeholder="Place your text in English...")
out = gr.Textbox(lines=1, label="Sentiment")
gr.Interface(text2text_sentiment, inputs=in_para, outputs=out).launch()