from transformers import pipeline, set_seed
import gradio as gr

model_name = "distilgpt2"
gpt2_pipeline = pipeline("text-generation", model=model_name)
set_seed(42)

def generate(text):
    response = gpt2_pipeline(text, max_length=20, num_return_sequences=5)
    return response

in_text = gr.Textbox(lines=1, label="English", placeholder="English text here")
out = gr.Textbox(lines=1, label="Generated text")

gr.Interface(generate, inputs=in_text, outputs=out).launch()