# %%
import gradio as gr
import joblib
import numpy as np
loaded_rf_2way = joblib.load("STPI_2WAY_RandomForest.joblib")
loaded_rf_3way = joblib.load("STPI_3WAY_RandomForest.joblib")


def STPI(t_0_5_MaxValue,t_1_0_MaxValue,t_2_0_MaxValue,
# Acc_0_5__1_0_MaxValue,
Abs_Diff_t_0_5_MaxValue,Abs_Diff_t_1_0_MaxValue,Abs_Diff_t_2_0_MaxValue,Optional_Custom_Message='No_Message'):
    print('------------------')
    print(Optional_Custom_Message)
    
    X = [t_0_5_MaxValue,t_1_0_MaxValue,t_2_0_MaxValue,
    # Acc_0_5__1_0_MaxValue,
    Abs_Diff_t_0_5_MaxValue,Abs_Diff_t_1_0_MaxValue,Abs_Diff_t_2_0_MaxValue]
    print(X)
    outcome_decoded = ['Normal','Keratoconic','Suspect']
    file_object = open('stpi_data.txt', 'a')
    file_object.write(str(t_0_5_MaxValue))
    file_object.write(';')
    file_object.write(str(t_1_0_MaxValue))
    file_object.write(';')
    file_object.write(str(t_2_0_MaxValue))
    file_object.write(';')
    # file_object.write(str(Acc_0_5__1_0_MaxValue))
    # file_object.write(';')
    file_object.write(str(Abs_Diff_t_0_5_MaxValue))
    file_object.write(';')
    file_object.write(str(Abs_Diff_t_1_0_MaxValue))
    file_object.write(';')
    file_object.write(str(Abs_Diff_t_2_0_MaxValue))
    file_object.write(';')
    file_object.write(Optional_Custom_Message)
    file_object.write('\n')
    file_object.close()

    result_2way = loaded_rf_2way.predict([X])
    print('The patient is ', outcome_decoded[int(result_2way)], ' through the 2way method')

    probs_2way = loaded_rf_2way.predict_proba([X])
    probs_2way = str(np.round(probs_2way[0], decimals=2))
    print('2 way class Probabilities (Normal/KC) are ', probs_2way)

    result_3way = loaded_rf_3way.predict([X])

    probs_3way = loaded_rf_3way.predict_proba([X])
    probs_3way = str(np.round(probs_3way[0], decimals=2))
    print('3 way class Probabilities (Normal/Suspect/KC) are ', probs_3way)

    if result_2way == 0:
        print('The patient is ', outcome_decoded[int(result_3way)], 'through the 3way method')
        # result = 'The 3-way classification resulted in a ', outcome_decoded[int(result_3way)] + ' patient.'
        # further_analysis = 'Futher analysis using the 2-way classification resulted in a ' + outcome_decoded[int(result_2way)] + ' label.'
        return 'The 3-way classification resulted in a ' + outcome_decoded[int(result_3way)] + ' patient. Futher analysis using the 2-way classification resulted in a ' + outcome_decoded[int(result_2way)] + ' label. ' + '2 way class Probabilities (Normal/KC) are ' + probs_2way + ' and 3 way class Probabilities (Normal/Suspect/KC) are ' + probs_3way

    # result = 'The 2-way classification resulted in a ', outcome_decoded[int(result_2way)] + ' patient.'
    # further_analysis = 'Futher analysis using the 3-way classification resulted in a ' + outcome_decoded[int(result_3way)] + ' label.'

    return 'The 2-way classification resulted in a ' + outcome_decoded[int(result_2way)] + ' patient. Futher analysis using the 3-way classification resulted in a ' + outcome_decoded[int(result_3way)] + ' label. ' + '2 way class Probabilities (Normal/KC) are ' + probs_2way + ' and 3 way class Probabilities (Normal/Suspect/KC) are ' + probs_3way

iface = gr.Interface(
    fn=STPI, 
    title='STPI Calculator',
    description='Calculates the STPI through summarized tomographic parameters. Beta version by Prof. Shady Awwad, Jad Assaf MD and Jawad Kaisania.',
    inputs=["number", "number","number", 
    # "number",
    "number", "number","number","text"],
    outputs="text")
iface.launch(
    # share=True
    )
# %%
