#!/usr/bin/env python
# coding: utf-8

# In[6]:


physical_health = 4
mental_health = 3
social_life = 3
academic = 10
relationship = 5
perseverance = 5
financial_support = 7

# the index is calculated by the average of the 7 factors divided by the stdev of the 7 values 
import math

average = (physical_health + mental_health + social_life + academic + relationship + perseverance + financial_support) / 7
stdev = math.sqrt((math.pow(physical_health - average, 2) + math.pow(mental_health - average, 2) + math.pow(social_life - average, 2) + math.pow(academic - average, 2) + math.pow(relationship - average, 2) + math.pow(perseverance - average, 2) + math.pow(financial_support - average, 2)) / 7)
index = average / stdev
print("The wlb index is: " + str(index))


# In[7]:


# use sns to draw a figure consists of 7 horizontal bars with different colors
import seaborn as sns
import matplotlib.pyplot as plt
sns.set(style="whitegrid")
fig, ax = plt.subplots(figsize=(10, 5), dpi=200)
ax = sns.barplot(x=[physical_health, mental_health, social_life, academic, relationship, perseverance, financial_support], y=["Physical Health", "Mental Health", "Social Life", "Academic", "Relationship", "Perseverance", "Financial Support"], palette="Blues_d")
ax.set(xlim=(0, 10), ylabel="", xlabel="Ability Level")
plt.title("Master WLB Index of Jack: " + str(round(index, 2)))
plt.show()


# In[13]:


# create a gradio app as interface
# display the sns figure in the interface using gradio.Plot
import gradio as gr

def wlb_index(physical_health, mental_health, social_life, academic, relationship, perseverance, financial_support):
    average = (physical_health + mental_health + social_life + academic + relationship + perseverance + financial_support) / 7
    stdev = math.sqrt((math.pow(physical_health - average, 2) + math.pow(mental_health - average, 2) + math.pow(social_life - average, 2) + math.pow(academic - average, 2) + math.pow(relationship - average, 2) + math.pow(perseverance - average, 2) + math.pow(financial_support - average, 2)) / 7)
    index = average / stdev
    sns.set(style="whitegrid")
    fig, ax = plt.subplots(figsize=(10, 5), dpi=200)
    ax = sns.barplot(x=[physical_health, mental_health, social_life, academic, relationship, perseverance, financial_support], y=["Physical Health", "Mental Health", "Social Life", "Academic", "Relationship", "Perseverance", "Financial Support"], palette="Blues_d")
    ax.set(xlim=(0, 10), ylabel="", xlabel="Ability Level")
    plt.title("Master WLB Index of Jack: " + str(round(index, 2)))
    return plt

iface = gr.Interface(fn=wlb_index, inputs=["number", "number", "number", "number", "number", "number", "number"], outputs="plot")
 
iface.launch()
 


# In[ ]:




