from transformers import pipeline
import random
import gradio as gr
from translate import Translator
import torch
from transformers import AutoTokenizer, AutoModelForCausalLM 

def classfi(input):
  classifier= pipeline("sentiment-analysis")
  translator= Translator(from_lang="ko", to_lang="en")
  inputko=translator.translate(input)

  return classifier(inputko)

with gr.Blocks(css=".gradio-container {background-color: white}") as demo:
  name=gr.Textbox(label="하고 싶은 이야기를 적어 감정 분석하기 버튼을 눌러보세요")
  output=gr.Textbox(label="당신의 감정 상태를 알려줍니다.")
  greet_btn = gr.Button("감정 분석하기")
  greet_btn.click(fn=classfi, inputs=name, outputs=output)
  demo.launch(debug = True, share =False)
