import os
import gradio as gr
from scipy.io.wavfile import write, read
import subprocess

def inference(audio):
    
    os.makedirs("out", exist_ok=True)
    write('mix.wav', audio[0], audio[1])

    command = "python3 -m demucs -n mdx_extra_q -d cpu mix.wav -o out"
    process = subprocess.run(command, 
                             shell=True, 
                             stdin=subprocess.DEVNULL, 
                             stdout=subprocess.PIPE, 
                             stderr=subprocess.PIPE
                            )

    # Check if files exist before returning
    files = ["./out/mdx_extra_q/mix/vocals.wav",
             "./out/mdx_extra_q/mix/bass.wav",
             "./out/mdx_extra_q/mix/drums.wav",
             "./out/mdx_extra_q/mix/other.wav"]
    
    for file in files:
        if not os.path.isfile(file):
            print(f"File not found: {file}")
        else:
            print(f"File exists: {file}")

    return files
  
article = "Inspired by <p><a href='https://github.com/facebookresearch/demucs' target='_blank'>Demucs</a></p>\n<p>Copyright &copy; 2023 JP Madsen</p"

demo = gr.Interface(
  inference,
  gr.inputs.Audio(type = "numpy", label = "Input"), 
  [gr.outputs.Audio(type = "filepath", label = "Vocals"),
   gr.outputs.Audio(type = "filepath", label = "Bass"),
   gr.outputs.Audio(type = "filepath", label = "Drums"),
   gr.outputs.Audio(type = "filepath", label = "Other")
  ],
    #title = title,
    #description = description,
    article = article,
    theme = 'nuttea/Softblue',
    allow_flagging = "never"  
)

#demo.queue(concurrency_count = 10)
demo.launch()
