import collections
from numpy.core.defchararray import lower
import streamlit as st
import numpy as np
import pandas as pd
import zipfile
import io
import os
from streamlit.elements.image import image_to_url
import gzip
import requests
from io import BytesIO
from PIL import Image, ImageDraw
import base64
import datetime

def dell(ix):
    print("!!!!")
    st.session_state.results.pop(ix)


def app():

    st.title('AI-Generated Architecture')

    st.subheader('Download your images or choose which images you would like to remove from your working set.')



    d = datetime.datetime.now()

    zipObj = zipfile.ZipFile('ai_architecture.zip', 'w')

    deleteButtons = []


    for ix,result in enumerate( st.session_state.results ):

        with st.container():
            col1,col2 = st.columns(2)

            with col1:
                t = st.image(result['image'])

                with io.BytesIO() as output:
                    result['image'].save(output, format="JPEG")
                    contents = output.getvalue()

                    txt = str(ix+1)+") " + result['prompt']+" (temperature:"+ str(result['crazy']) + ", top k:" + str(result['k']) + ")"
        
                    zipObj.writestr(txt+".jpg",  contents )


            with col2:
                if(len(st.session_state.results) > 1):
                    st.button("delete ", key=ix, on_click=dell, kwargs=dict(ix=ix) )

            m = st.markdown("""
            <hr />""", unsafe_allow_html=True)

    zipObj.close()


    st.download_button(
         label="Download Images as Zip File",
         data=open('ai_architecture.zip', 'rb'),
         file_name='ai_architecture '+d.strftime("%m-%d-%Y")+'.zip',
         mime='application/zip'
    )

    

