from fastapi import FastAPI, Request, Response

filenames = ["js/sketch.js"]
contents = '\n'.join([f"<script type='text/javascript' src='{x}'></script>" for x in filenames])

app = FastAPI()

@app.middleware("http")
async def insert_js(request: Request, call_next):
    path = request.scope['path']  # get the request route
    response = await call_next(request)
    
    if path == "/":
        response_body = ""
        async for chunk in response.body_iterator:
            response_body += chunk.decode()

        some_javascript = """
        <script type="text/javascript">
        src="https://cdnjs.cloudflare.com/ajax/libs/p5.js/1.6.0/p5.js">
        </script>
         <script src="sketch.js"></script>
        """
        
        response_body = response_body.replace("</headers>", some_javascript + "</headers>")
        response_body = response_body.replace("</body>", contents + "</body>")

        del response.headers["content-length"]

        return Response(
            content=response_body,
            status_code=response.status_code, 
            headers=dict(response.headers),
            media_type=response.media_type
        )

    return response