import streamlit as st
import pandas as pd 
import numpy as np 
import pickle
import json

# Load All Files

with open('best_model.pkl', 'rb') as file_1:
    model = pickle.load(file_1)

with open('model_scaler_std.pkl', 'rb') as file_2:
    model_scaler_std = pickle.load(file_2)

with open('model_scaler_rbst.pkl','rb') as file_3:
    model_scaler_rbst = pickle.load(file_3)

with open('list_numeric_robust.txt', 'r') as file_4:
    list_num_robust = json.load(file_4)

with open('list_numeric_standard.txt', 'r') as file_5:
    list_num_std = json.load(file_5)

with open('list_numeric_categoric.txt', 'r') as file_6:
    list_num_cat = json.load(file_6)

def run():
    with st.form(key='Heart_Failure_Prediction'):
        age = st.number_input('Age', min_value=16, max_value=100, value=59, step=1, help='Usia Pasien')
        creatinine_phosphokinase = st.number_input('Creatinine Phosphokinase', min_value=0, max_value=10000, value=280, step=10, help='Enzim CPK dalam darah (mcg/L)')
        ejection_fraction = st.number_input('Ejection Fraction', min_value=0, max_value=100, value=25, step=1, help='Persentase darah yang meninggalkan jantung (%)')
        platelets = st.number_input('Platelets', min_value=0, max_value=1000000, value=350000, step=100, help='Jumlah trombosit dalam darah (kiloplatelet/mL)')
        serum_creatinine = st.number_input('Serum Creatinine', min_value=0.0, max_value=20.0, value=1.0, step=0.1, help='Tingkat serum kreatinin dalam darah (mg/dL)')
        serum_sodium = st.number_input('Serum Sodium', min_value=0, max_value=200, value=145, step=1, help='Tingkat natrium serum dalam darah (mEq/L)')
        time = st.number_input('Time', min_value=0, max_value=500, value=78, step=1, help='Periode tindak lanjut pasien (hari)')
      
        anaemia = st.selectbox('Anaemia', ('No', 'Yes'), help='Penurunan sel darah merah atau hemoglobin')
        diabetes = st.selectbox('Diabetes', ('No', 'Yes'), help='Apakah pasien memiliki diabetes')
        high_blood_pressure = st.selectbox('High Blood Pressure', ('No', 'Yes'), help='Apakah pasien memiliki tekanan darah tinggi')
        sex = st.selectbox('Sex', ('Female', 'Male'), help='Jenis kelamin pasien')
        smoking = st.selectbox('Smoking', ('No', 'Yes'), help='Apakah pasien merokok')

        submitted = st.form_submit_button('Predict')

    # Create New Data
    data_inf = {
        'age': age,
        'creatinine_phosphokinase': creatinine_phosphokinase,
        'ejection_fraction': ejection_fraction,
        'platelets': platelets,
        'serum_creatinine': serum_creatinine,
        'serum_sodium': serum_sodium,
        'time': time,
        'anaemia': 1 if anaemia == 'Yes' else 0,
        'diabetes': 1 if diabetes == 'Yes' else 0,
        'high_blood_pressure': 1 if high_blood_pressure == 'Yes' else 0,
        'sex': 1 if sex == 'Male' else 0,
        'smoking': 1 if smoking == 'Yes' else 0
    }
    
    # Create a DataFrame from the dictionary data_inf
    data_inf = pd.DataFrame([data_inf], index=None)
    st.dataframe(data_inf)

    if submitted:
        # Reorder the columns of data_inf to match the order used during training
        data_inf = data_inf[list_num_robust + list_num_std + list_num_cat]

        # Feature Scaling
        data_inf_num_rbs_scaled = model_scaler_rbst.transform(data_inf[list_num_robust])
        data_inf_num_std_scaled = model_scaler_std.transform(data_inf[list_num_std])

        # Combine the scaled features with the categorical features
        data_inf_final = np.concatenate([data_inf_num_rbs_scaled, data_inf_num_std_scaled, data_inf[list_num_cat]], axis=1)

        # Predict using the model
        y_pred_inf = model.predict(data_inf_final)
    
        prediction_label = 'Survived' if y_pred_inf == 0 else 'Not Survived'
        st.write('Prediction : ', prediction_label)

if __name__ == '__main__':
    run()
