import streamlit as st
import pandas as pd 
import seaborn as sns
import matplotlib.pyplot as plt 
import plotly.express as px
from PIL import Image



import pandas as pd
import streamlit as st
import seaborn as sns
import matplotlib.pyplot as plt
from PIL import Image

def visualize_numeric_distribution(df, column):
    # Create subplots
    fig, axs = plt.subplots(1, 2, figsize=(12, 6))

    # Distribution plot
    sns.histplot(data=df, x=column, hue='DEATH_EVENT', multiple='stack', kde=True, ax=axs[0])
    axs[0].set_title('Distribution of {}'.format(column))
    axs[0].axvline(df[column].mean(), color='red', linestyle='dashed', linewidth=2, label='Mean')
    axs[0].axvline(df[column].median(), color='green', linestyle='dashed', linewidth=2, label='Median')
    axs[0].set_xlabel(column)
    axs[0].set_ylabel('Count')
    axs[0].legend()

    # Box plot
    sns.boxplot(data=df, x='DEATH_EVENT', y=column, ax=axs[1])
    axs[1].set_title('Box Plot of {}'.format(column))
    axs[1].set_xlabel('DEATH_EVENT')
    axs[1].set_ylabel(column)

    plt.tight_layout()
    return fig

def visualize_death_event_by_categorical(df, column):
    # Group data by column and death event, and calculate the count
    counts = df.groupby([column, 'DEATH_EVENT']).size().reset_index(name='Count')

    # Bar plot
    fig, axs = plt.subplots(1, 2, figsize=(15, 6))
    sns.barplot(x='DEATH_EVENT', y='Count', hue=column, data=counts, ax=axs[0])
    for p in axs[0].patches:
        height = p.get_height()
        axs[0].text(p.get_x() + p.get_width()/2., height + 3, '{:1.0f}'.format(height), ha="center")
    axs[0].set_title('Death Event Count by {}'.format(column))
    axs[0].set_xticklabels(['Survival', 'Death'])
    axs[0].set_xlabel('Death Event')
    axs[0].set_ylabel('Count')

    # Pie chart
    labels = []
    sizes = []
    for value in df[column].unique():
        survival_count = df[(df[column] == value) & (df['DEATH_EVENT'] == 0)].shape[0]
        death_count = df[(df[column] == value) & (df['DEATH_EVENT'] == 1)].shape[0]
        labels.append('{} - Survival'.format(value))
        labels.append('{} - Death'.format(value))
        sizes.extend([survival_count, death_count])
    axs[1].pie(sizes, labels=labels, autopct='%1.1f%%', shadow=True, startangle=90)
    axs[1].set_title('Death Event Percentage')
    axs[1].axis('equal')

    plt.tight_layout()
    return fig

def run():
    st.set_option('deprecation.showPyplotGlobalUse', False)

    #buat title
    st.title('Heart Failure Prediction')

    #Sub Header
    st.subheader('Analisa ')

    #tambah gambar
    image = Image.open('Thumb.jpg')
    st.image(image, caption='Heart Failure')

    #menambah deskripsi
    st.write('Page ini merupakan eksplorasi sederhana pada data set Heart Failure.')

    #garis lurus
    st.markdown('---')

    #load dataframe
    data = pd.read_csv('https://raw.githubusercontent.com/IwanKurniawann/dataset/main/h8dsft_P1G3_iwan_kurniawan.csv')
    st.dataframe(data)

    # List of columns
    numerical_columns = ['age', 'creatinine_phosphokinase', 'ejection_fraction', 'platelets', 'serum_creatinine', 'serum_sodium', 'time']
    categorical_columns = ['anaemia', 'diabetes', 'high_blood_pressure', 'sex', 'smoking']

    # Visualize death event by categorical columns
    column_visualize = st.selectbox('Categorical: ', categorical_columns)
    fig = visualize_death_event_by_categorical(data, column_visualize)
    st.pyplot(fig)

    # Visualize numeric distributions
    column_visualize = st.selectbox('Numerical: ', numerical_columns)
    fig = visualize_numeric_distribution(data, column_visualize)
    st.pyplot(fig)

if __name__ == '__main__':
    run()
