#import pipeline function from huggingface transformers library
from transformers import pipeline
import gradio as gr

#choosing the model distilbart for NER
get_completion = pipeline(
                 "ner", model="dslim/bert-base-NER"
                 )

def merge_tokens(tokens):
    merged_tokens = []
    for token in tokens:
        if merged_tokens and token['entity'].startswith('I-') and merged_tokens[-1]['entity'].endswith(token['entity'][2:]):
            # If current token continues the entity of the last one, merge them
            last_token = merged_tokens[-1]
            last_token['word'] += token['word'].replace('##', '')
            last_token['end'] = token['end']
            last_token['score'] = (last_token['score'] + token['score']) / 2
        else:
            # Otherwise, add the token to the list
            merged_tokens.append(token)

    return merged_tokens

def ner(input):
    output = get_completion(input)
    merged_tokens = merge_tokens(output)
    return {"text":input, "entities":merged_tokens}


#create an interface for the model
demo = gr.Interface(ner, 
                  inputs = [gr.Textbox(label="Text to find entities", lines=7)],#customize the UI with gradio components textbox, and size of text fields
                  outputs = [gr.HighlightedText(label="Text with entitites", lines=5)],#customize the UI with gradio components textbox,and size of text fields
                  title = "Named Entity Recognition",#add title for app
                  description = "Find named entities!",
                  allow_flagging = "never",
                  #Use examples tag to include examples for the application
                  examples=["Jim bought 300 shares of Acme Corp. in 2006.", "Washington is the capital of the USA"])

demo.launch()
