!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("three")):"function"==typeof define&&define.amd?define(["exports","three"],t):t((e=e||self).SixDOF={},e.THREE)}(this,(function(e,t){"use strict";var r,n,i,o="#define GLSLIFY 1\n\n/** Small util to get the depth texture */\nvec3 getDepth(sampler2D depth, vec2 uvs) {\n\n    /** Return the depth texture */\n    return texture2D(depth, uvs).rgb;\n}\n\n/** Small util to get the lower half of a texture (in our case the depthmap) */\nvec3 getDepthFromBottomHalf(sampler2D tex, vec2 uvs) {\n    \n    /** Chop the uvs to the lower half of the texture (i.e top-bottom) */\n    vec2 lower_half_uvs = vec2(uvs.x, uvs.y * 0.5);\n\n    /** Return the depth texture */\n    return texture2D(tex, lower_half_uvs).rgb;\n}\n\n/** Small util to get the upper half of a texture (in our case the color texture) */\nvec3 getColorFromUpperHalf(sampler2D tex, vec2 uvs) {\n    \n    /** Chop the uvs to the lower half of the texture (i.e top-bottom) */\n    vec2 upper_half_uvs = vec2(uvs.x, (uvs.y * 0.5) + 0.5);\n\n    /** Return the depth texture */\n    return texture2D(tex, upper_half_uvs).rgb;\n}\n\n// Uniforms\nuniform sampler2D colorTexture;\nuniform sampler2D depthTexture;\nuniform float debugDepth;\nuniform float opacity;\n\n// Varyings from vertex program\nvarying vec2 vUv;\n\n// Internal\nvec3 depth;\nvec3 color;\n\nvoid main() {\n\n/** Use compiler definitions to know which method to pick */\n#ifdef TOP_BOTTOM\n    depth = getDepthFromBottomHalf(colorTexture, vUv);\n    color = getColorFromUpperHalf(colorTexture, vUv);\n#endif\n\n#ifdef SEPERATE\n    depth = getDepth(depthTexture, vUv);\n    color = texture2D(colorTexture, vUv).rgb;\n#endif\n\n    // Mix the depth and color based on debugDepth value\n    vec3 depthColorMixer = mix(color, depth , debugDepth);\n\n    // Render dat fragment\n    gl_FragColor = vec4(depthColorMixer, opacity);\n}\n",s="#define GLSLIFY 1\n\n/** Small util to get the depth texture */\nvec3 getDepth(sampler2D depth, vec2 uvs) {\n\n    /** Return the depth texture */\n    return texture2D(depth, uvs).rgb;\n}\n\n/** Small util to get the lower half of a texture (in our case the depthmap) */\nvec3 getDepthFromBottomHalf(sampler2D tex, vec2 uvs) {\n    \n    /** Chop the uvs to the lower half of the texture (i.e top-bottom) */\n    vec2 lower_half_uvs = vec2(uvs.x, uvs.y * 0.5);\n\n    /** Return the depth texture */\n    return texture2D(tex, lower_half_uvs).rgb;\n}\n\n// Uniforms\nuniform sampler2D colorTexture;\nuniform sampler2D depthTexture;\nuniform float pointSize;\nuniform float displacement;\n\n// Varyings passed to fragment\nvarying vec2 vUv;\n\n// Internal\nfloat depth;\n\nvoid main() {\n\n    /** Transform and pass to fragment shader */\n    vUv = uv;\n\n    /** Set the GL point size for when rendering points, ignored otherwise */\n    gl_PointSize = pointSize;\n\n/** Use compiler definitions to know which method to pick */\n#ifdef TOP_BOTTOM\n    depth = getDepthFromBottomHalf(colorTexture, vUv).r;\n#endif\n\n#ifdef SEPERATE\n    depth = getDepth(depthTexture, vUv).r;\n#endif\n\n    /** \n    * Invert the normals (since they are pointing outwards) and \n    * move the position on the normal direction scaled by the \n    * displacement which is the depth for the current vertex\n    * multiplied by a `displacement` scalaer\n    **/\n    float disp = displacement * depth;\n    vec3 offset = position + (-normal) * disp;\n\n    /** Transform */\n    gl_Position = projectionMatrix *\n                    modelViewMatrix *\n                    vec4(offset, 1.0);\n}",a={colorTexture:{type:"t",value:null},depthTexture:{type:"t",value:null},time:{type:"f",value:0},opacity:{type:"f",value:1},pointSize:{type:"f",value:3},debugDepth:{type:"f",value:0},displacement:{type:"f",value:1}};(r=e.MeshDensity||(e.MeshDensity={}))[r.LOW=64]="LOW",r[r.MEDIUM=128]="MEDIUM",r[r.HIGH=256]="HIGH",r[r.EXTRA_HIGH=512]="EXTRA_HIGH",r[r.EPIC=1024]="EPIC",(n=e.Style||(e.Style={}))[n.WIRE=0]="WIRE",n[n.POINTS=1]="POINTS",n[n.MESH=2]="MESH",(i=e.TextureType||(e.TextureType={}))[i.TOP_BOTTOM=0]="TOP_BOTTOM",i[i.SEPERATE=1]="SEPERATE";class u{constructor(){this.type=e.TextureType.SEPERATE,this.density=e.MeshDensity.HIGH,this.style=e.Style.MESH,this.displacement=4,this.radius=6}}class p extends t.Object3D{constructor(r,n,i){super(),this.props=new u,this.material=new t.ShaderMaterial({uniforms:a,vertexShader:s,fragmentShader:o,transparent:!0,side:t.BackSide}),this.setProps(this.props,i),this.setShaderDefines(this.material,[e.TextureType[this.props.type]]),p.geometry||(p.geometry=this.createSphereGeometry(this.props.radius,this.props.density)),this.assignTexture(this.props.type,r,n),this.displacement=this.props.displacement,super.add(this.createMesh(p.geometry,this.material,this.props.style))}setShaderDefines(e,t){t.forEach((function(t){return e.defines[t]=""}))}createSphereGeometry(e,r){return new t.SphereBufferGeometry(e,r,r)}setProps(e,t){if(t)for(var r in t)e[r]?e[r]=t[r]:console.warn("THREE.SixDOF: Provided ".concat(r," in config but it is not a valid property and being ignored"))}assignTexture(t,r,n){if(t===e.TextureType.SEPERATE){if(!n)throw new Error("When using seperate texture type, depthmap must be provided");this.depth=this.setDefaultTextureProps(n)}this.texture=this.setDefaultTextureProps(r)}setDefaultTextureProps(e){return e.minFilter=t.NearestFilter,e.magFilter=t.LinearFilter,e.format=t.RGBFormat,e.generateMipmaps=!1,e}createMesh(r,n,i){switch(i){case e.Style.WIRE:return this.material.wireframe||(this.material.wireframe=!0),new t.Mesh(r,n);case e.Style.MESH:return this.material.wireframe&&(this.material.wireframe=!1),new t.Mesh(r,n);case e.Style.POINTS:return new t.Points(r,n)}}toggleDepthDebug(e){this.material.uniforms.debugDepth.value=null!=e?e:!this.material.uniforms.debugDepth.value}set displacement(e){this.material.uniforms.displacement.value=e}set depth(e){this.material.uniforms.depthTexture.value=e}set texture(e){this.material.uniforms.colorTexture.value=e}set opacity(e){this.material.uniforms.opacity.value=e}set pointSize(e){this.material.uniforms.pointSize.value=e}get config(){return this.props}get opacity(){return this.material.uniforms.opacity.value}get pointSize(){return this.material.uniforms.pointSize.value}get displacement(){return this.material.uniforms.displacement.value}get texture(){return this.material.uniforms.colorTexture.value}get depth(){return this.material.uniforms.opacity.value}}p.geometry=void 0,e.Viewer=p,Object.defineProperty(e,"__esModule",{value:!0})}));
//# sourceMappingURL=three-6dof.min.js.map
