import os
import gradio as gr
import numpy as np
import random
import torch
import subprocess
import time
import requests
import json
import threading

import base64
from io import BytesIO
from PIL import Image
from huggingface_hub import login


myip_spr = os.environ["myip_spr"]
myip_clx = os.environ["myip_clx"]
myport = os.environ["myport"]

SPR = f"http://{myip_spr}:{myport}"
CLX = f"http://{myip_clx}:{myport}"


print('=='*20)
print(os.system("hostname -i"))
print(SPR)
print(CLX)

prompt_examples_list =  [
    ['A cascading waterfall tumbles down moss-covered rocks, surrounded by a lush and vibrant forest.'],
    ['In a serene garden, delicate cherry blossoms fall like pink snowflakes.'],
    ['A breathtaking mountain range towers above a picturesque valley, with a winding river reflecting the surrounding beauty.'],
    ['A serene beach scene with turquoise waters, palm trees swaying in the breeze, and a radiant sunset painting the sky in hues of orange and pink.'],
    ['After the rain, sunlight breaks through the clouds, illuminating the verdant fields.']
    ]
CN_prompt_examples_list = [
    ['瀑布从长满苔藓的岩石上奔流而下，周围是一片茂密而充满活力的森林。'],
    ['在一个宁静的花园里，精致的樱花像粉色的雪花一样飘落。'],
    ['壮丽的山脉高耸在风景如画的山谷之上，一条蜿蜒的河流映衬着周围的美景。'],
    ['一个宁静的海滩场景，湛蓝的海水，微风中摇曳的棕榈树，夺目的日落将天空染成橙色和粉红色的色调。'],
    ['雨后，阳光穿过云层，照亮了青翠的田野。']
]    

def update_language(value):
    if value == "zh-CN":
        return [gr.update(visible=False), gr.update(visible=True)]
    else:
        return [gr.update(visible=True), gr.update(visible=False)]    

def url_requests(url, data):
    resp = requests.post(url, data=json.dumps(data))
    img_str = json.loads(resp.text)["img_str"]
    location = json.loads(resp.text)["ip"]

    img_byte = base64.b64decode(img_str)
    img_io = BytesIO(img_byte)  # convert image to file-like object
    img = Image.open(img_io)   # img is now PIL Image object

    return img, location

def img2img_generate(url, source_img, prompt, steps=25, strength=0.75, seed=42, guidance_scale=7.5, hidden=""):
    
    if hidden != os.environ["front_token"]:
        return None
    
    print('=*'*20)
    print(type(source_img))
    print("prompt: ", prompt)
    buffered = BytesIO()
    source_img.save(buffered, format="JPEG")
    img_b64 = base64.b64encode(buffered.getvalue())

    data = {"source_img": img_b64.decode(), "prompt": prompt, "steps": steps,
            "guidance_scale": guidance_scale, "seed": seed, "strength": strength,
            "token": os.environ["access_token"]}

    start_time = time.time()
    img, location = url_requests(url, data)
    print("*="*20)
    print("location: ", location)
    print("cost: ", time.time() - start_time)

    return img

def toggle_content():
    if toggle_content.collapsed:
        toggle_content.collapsed = False
        return "Content expanded"
    else:
        toggle_content.collapsed = True
        return "Content collapsed"

def txt2img_example_input(value):
    print('6/12/2023', value)
    return value

def txt2img_generate(url, prompt, steps=25, seed=42, guidance_scale=7.5, hidden=""):
        
    if hidden != os.environ["front_token"]:
        return None

    print("prompt: ", prompt)
    print("steps: ", steps)
    print("url: ", url)
    data = {"prompt": prompt,
        "steps": steps, "guidance_scale": guidance_scale, "seed": seed,
        "token": os.environ["access_token"]}
    start_time = time.time()
    img, location = url_requests(url, data)

    print("*="*20)
    print("location: ", location)
    print("cost: ", time.time() - start_time)

    return img

title = """
# Stable Diffusion Inference Acceleration Comparison
"""
CN_title = """
# Stable Diffusion 推理加速比较
"""

subtitle = """
# between 4th Gen and 3rd Gen Intel Xeon Scalable Processor
"""
CN_subtitle = """
## 第四代和第三代英特尔至强可扩展处理器
"""
        
md = """
Have fun and try your own prompts and see a up to 9x performance acceleration on the new 4th Gen Intel Xeon using <a href=\"https://github.com/intel/intel-extension-for-transformers\">**Intel Extension for Transformers**</a>. You may also want to try creating your own Stable Diffusion with few-shot fine-tuning. Please refer to our <a href=\"https://medium.com/intel-analytics-software/personalized-stable-diffusion-with-few-shot-fine-tuning-on-a-single-cpu-f01a3316b13\">blog</a> and <a href=\"https://github.com/intel/neural-compressor/tree/master/examples/pytorch/diffusion_model/diffusers/textual_inversion\">code</a> available in <a href=\"https://github.com/intel/neural-compressor\">**Intel Neural Compressor**</a> and <a href=\"https://github.com/huggingface/diffusers\">**Hugging Face Diffusers**</a>.
"""

CN_md = """
请尽情体验这些功能！利用<a href=\"https://github.com/intel/intel-extension-for-transformers\">**Intel Extension for Transformers**</a>和新一代英特尔至强可扩展处理器可获得高达9倍的性能提升。您还可以使用少样本微调的方式来创建属于自己的稳定扩散模型。请参考我们的<a href=\"https://medium.com/intel-analytics-software/personalized-stable-diffusion-with-few-shot-fine-tuning-on-a-single-cpu-f01a3316b13\">博客</a>和<a href=\"https://github.com/intel/neural-compressor/tree/master/examples/pytorch/diffusion_model/diffusers/textual_inversion\">代码</a>，这些资源可在<a href=\"https://github.com/intel/neural-compressor\">**Intel Neural Compressor**</a>和<a href=\"https://github.com/huggingface/diffusers\">**Hugging Face Diffusers**</a>的GitHub上找到。
"""

legal = """
Performance varies by use, configuration and other factors. Learn more at www.Intel.com/PerformanceIndex. Performance results are based on testing as of dates shown in configurations and may not reflect all publicly available updates.  See backup for configuration details.  No product or component can be absolutely secure.
© Intel Corporation. Intel, the Intel logo, and other Intel marks are trademarks of Intel Corporation or its subsidiaries. Other names and brands may be claimed as the property of others.
"""

CN_legal = """
性能因使用、配置和其他因素而异。想要了解更多信息，请访问www.Intel.com/PerformanceIndex。
- 性能结果基于所示配置的测试，可能不反映所有公开可用的更新。
- 有关配置详细信息，请参考备份文件。没有任何产品/组件绝对安全。
- © 英特尔公司。英特尔、英特尔标识和其他英特尔商标是英特尔公司或其子公司的商标。其他名称和品牌可能归他人所有。"""

details = """
- 4th Gen Intel Xeon Scalable Processor Inference. Test by Intel on 10/06/2023. Ubuntu 22.04.1 LTS, Intel Extension for Transformers(1.1.dev154+g448cc17e), Transformers 4.28.1, Diffusers 0.12.1, oneDNN v2.7.4.
- 3rd Gen Intel Xeon Scalable Processor Inference: Test by Intel on 10/06/2023. Ubuntu 22.04.1 LTS, PyTorch Nightly build (2.0.0.dev20230105+cpu), Transformers 4.25.1, Diffusers 0.11.1, oneDNN v2.7.2.
"""

CN_details = """
- 英特尔第四代至强可扩展处理器推理。由英特尔于2023年6月10日测试。Ubuntu 22.04.1 LTS，英特尔Transformer扩展（1.1.dev154+g448cc17e），Transformer 4.28.1，Diffusers 0.12.1，oneDNN v2.7.4。
- 英特尔第三代至强可扩展处理器推理：由英特尔于2023年6月10日测试。Ubuntu 22.04.1 LTS，PyTorch Nightly构建（2.0.0.dev20230105+cpu），Transformer 4.25.1，Diffusers 0.11.1，oneDNN v2.7.2。
"""

# warining = """
#  ⚠ Upgrading, service temporarily paused.
# """

css = '''
    .instruction{position: absolute; top: 0;right: 0;margin-top: 0px !important}
    .arrow{position: absolute;top: 0;right: -110px;margin-top: -8px !important}
    #component-4, #component-3, #component-10{min-height: 0}
    .duplicate-button img{margin: 0}
    #img_1, #img_2, #img_3, #img_4{height:15rem}
    #mdStyle{font-size: 0.7rem}
    #titleCenter {text-align:center}

'''

random_seed = random.randint(0, 2147483647)

with gr.Blocks(css=css) as demo:
    # gr.Markdown(warining, elem_id="warning")
    with gr.Box(visible=False) as zh:
        gr.Markdown(CN_title, elem_id='titleCenter')
        gr.Markdown(CN_subtitle, elem_id='titleCenter')
        gr.Markdown(CN_md)

        with gr.Tab("文字转图片"):
            with gr.Row() as text_to_image:
                with gr.Column():
                    prompt = gr.inputs.Textbox(label='提示词', default='a photo of an astronaut riding a horse on mars')
                    inference_steps = gr.inputs.Slider(1, 100, label='采样步数 - 步数越长质量越高 ', default=20, step=1)
                    seed = gr.inputs.Slider(0, 2147483647, label='随机种子', default=random_seed, step=1)
                    guidance_scale = gr.inputs.Slider(1.0, 20.0, label='引导程度 - 提示词对结果的影响程度', default=7.5, step=0.1)
                    hidden = gr.Textbox(label='hidden', value=os.environ["front_token"], visible=False)
                    txt2img_button = gr.Button("生成图片", variant="primary")
                    url_SPR_txt = gr.Textbox(label='url_SPR_txt', value=SPR, visible=False)
                    url_CLX_txt = gr.Textbox(label='url_CLX_txt', value=CLX, visible=False)

                with gr.Column():
                    result_image_1 = gr.Image(label="第四代英特尔至强可扩展处理器 (SPR)", elem_id="img_1")
                    result_image_2 = gr.Image(label="第三代英特尔至强可扩展处理器 (ICX)", elem_id="img_2")

            txt2img_input = gr.Textbox(visible=False)
            
            gr.Examples(
                    examples=prompt_examples_list,
                    inputs=txt2img_input,
                    outputs=prompt,
                    fn=txt2img_example_input,
                    cache_examples=True,
                    label="示例"
            )
        
        with gr.Tab("图片转图片"):
            with gr.Row() as image_to_image:
                with gr.Column():
                    source_img = gr.Image(source="upload", type="pil", value="https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg")
                    prompt_2 = gr.inputs.Textbox(label='提示词', default='A fantasy landscape, trending on artstation')
                    inference_steps_2 = gr.inputs.Slider(1, 100, label='采样步数 - 步数越长质量越高', default=20, step=1)
                    seed_2 = gr.inputs.Slider(0, 2147483647, label='随机种子', default=random_seed, step=1)
                    guidance_scale_2 = gr.inputs.Slider(1.0, 20.0, label='引导程度 - 提示词对结果的影响程度', default=7.5, step=0.1)
                    strength = gr.inputs.Slider(0.0, 1.0, label='强度级别 - 强度增加时噪声也变大', default=0.75, step=0.01)
                    hidden_2 = gr.Textbox(label='hidden', value=os.environ["front_token"], visible=False)
                    img2img_button = gr.Button("生成图片", variant="primary")
                    url_SPR = gr.Textbox(label='url_SPR', value=SPR, visible=False)
                    url_CLX = gr.Textbox(label='url_CLX', value=CLX, visible=False)

                with gr.Column():
                    result_image_3 = gr.Image(label="第四代英特尔至强可扩展处理器 (SPR)", elem_id="img_3")
                    result_image_4 = gr.Image(label="第三代英特尔至强可扩展处理器 (ICX)", elem_id="img_4")
        with gr.Accordion("附加信息" , open=False) as area_crazy_fn:
            gr.Markdown("**测试配置详情:**", elem_id='mdStyle')
            gr.Markdown(CN_details, elem_id='mdStyle')

            gr.Markdown("**注意事项和免责声明:**", elem_id='mdStyle')
            gr.Markdown(CN_legal, elem_id='mdStyle')

    with gr.Box(visible=False) as Eng:
        gr.Markdown(title)
        gr.Markdown(subtitle)
        gr.Markdown(md)

        with gr.Tab("Text-to-Image"):
            with gr.Row() as text_to_image:
                with gr.Column():
                    prompt = gr.inputs.Textbox(label='Prompt', default='a photo of an astronaut riding a horse on mars')
                    inference_steps = gr.inputs.Slider(1, 100, label='Inference Steps - increase the steps for better quality (e.g., avoiding black image) ', default=20, step=1)
                    seed = gr.inputs.Slider(0, 2147483647, label='Seed', default=random_seed, step=1)
                    guidance_scale = gr.inputs.Slider(1.0, 20.0, label='Guidance Scale - how much the prompt will influence the results', default=7.5, step=0.1)
                    hidden = gr.Textbox(label='hidden', value=os.environ["front_token"], visible=False)
                    txt2img_button = gr.Button("Generate Image", variant="primary")
                    url_SPR_txt = gr.Textbox(label='url_SPR_txt', value=SPR, visible=False)
                    url_CLX_txt = gr.Textbox(label='url_CLX_txt', value=CLX, visible=False)

                with gr.Column():
                    result_image_1 = gr.Image(label="4th Gen Intel Xeon Scalable Processors (SPR)", elem_id="img_1")
                    result_image_2 = gr.Image(label="3rd Gen Intel Xeon Scalable Processors (ICX)", elem_id="img_2")

            txt2img_input = gr.Textbox(visible=False)
            
            gr.Examples(
                    examples=prompt_examples_list,
                    inputs=txt2img_input,
                    outputs=prompt,
                    fn=txt2img_example_input,
                    cache_examples=True,
            )
        
        with gr.Tab("Image-to-Image text-guided generation"):
            with gr.Row() as image_to_image:
                with gr.Column():
                    source_img = gr.Image(source="upload", type="pil", value="https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg")
                    prompt_2 = gr.inputs.Textbox(label='Prompt', default='A fantasy landscape, trending on artstation')
                    inference_steps_2 = gr.inputs.Slider(1, 100, label='Inference Steps - increase the steps for better quality (e.g., avoiding black image) ', default=20, step=1)
                    seed_2 = gr.inputs.Slider(0, 2147483647, label='Seed', default=random_seed, step=1)
                    guidance_scale_2 = gr.inputs.Slider(1.0, 20.0, label='Guidance Scale - how much the prompt will influence the results', default=7.5, step=0.1)
                    strength = gr.inputs.Slider(0.0, 1.0, label='Strength - adding more noise to it the larger the strength', default=0.75, step=0.01)
                    hidden_2 = gr.Textbox(label='hidden', value=os.environ["front_token"], visible=False)
                    img2img_button = gr.Button("Generate Image", variant="primary")
                    url_SPR = gr.Textbox(label='url_SPR', value=SPR, visible=False)
                    url_CLX = gr.Textbox(label='url_CLX', value=CLX, visible=False)

                with gr.Column():
                    result_image_3 = gr.Image(label="4th Gen Intel Xeon Scalable Processors (SPR)", elem_id="img_3")
                    result_image_4 = gr.Image(label="3rd Gen Intel Xeon Scalable Processors (ICX)", elem_id="img_4")
        with gr.Accordion("Additional Info", open=False) as area_crazy_fn:
            gr.Markdown("**Test Configuration Details:**", elem_id='mdStyle')
            gr.Markdown(details, elem_id='mdStyle')

            gr.Markdown("**Notices and Disclaimers:**", elem_id='mdStyle')
            gr.Markdown(legal, elem_id='mdStyle')
            
    
    txt2img_button.click(fn=txt2img_generate, inputs=[url_SPR_txt, prompt, inference_steps, seed, guidance_scale, hidden], outputs=result_image_1, queue=False)
    txt2img_button.click(fn=txt2img_generate, inputs=[url_CLX_txt, prompt, inference_steps, seed, guidance_scale, hidden], outputs=result_image_2, queue=False)
    img2img_button.click(fn=img2img_generate, inputs=[url_SPR, source_img, prompt_2, inference_steps_2, strength, seed_2, guidance_scale_2, hidden_2], outputs=result_image_3, queue=False)
    img2img_button.click(fn=img2img_generate, inputs=[url_CLX, source_img, prompt_2, inference_steps_2, strength, seed_2, guidance_scale_2, hidden_2], outputs=result_image_4, queue=False)

    dt = gr.Textbox(label="Current language", visible=False)
    dt.change(update_language, inputs=dt, outputs=[Eng, zh])
    demo.load(None, inputs=None, outputs=dt, _js="() => navigator.language")


demo.queue(default_enabled=False, api_open=False, max_size=5).launch(debug=True, show_api=False)
