import streamlit as st

def display_ui():
    st.sidebar.image("/home/oem/Downloads/insightly_wbg.png", use_column_width=True)
    st.header("Data Analysis 📈")

    csv_files = st.file_uploader("Upload CSV files", type="csv", accept_multiple_files=True)
    if csv_files:
        llm = OpenAI(temperature=0)
        user_input = st.text_input("Question here:")

        # Iterate over each CSV file
        for csv_file in csv_files:
            with NamedTemporaryFile(delete=False) as f:
                f.write(csv_file.getvalue())
                f.flush()
                df = pd.read_csv(f.name)

                # Perform any necessary data preprocessing or feature engineering here
                # You can modify the code based on your specific requirements

                # Example: Accessing columns from the DataFrame
                # column_data = df["column_name"]

                # Example: Applying transformations or calculations to the data
                # transformed_data = column_data.apply(lambda x: x * 2)

                # Example: Using the preprocessed data with the OpenAI API
                # llm_response = llm.predict(transformed_data)

                if user_input:
                    # Pass the user input to the OpenAI agent for processing
                    agent = create_csv_agent(llm, f.name, verbose=True)
                    response = agent.run(user_input)

                    st.write(f"CSV File: {csv_file.name}")
                    st.write("Response:")
                    st.write(response)
