import openai

# Set up the OpenAI API credentials
openai.api_key = "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"

# Code snippet
code = """
from tempfile import NamedTemporaryFile
from langchain.agents import create_csv_agent
from langchain.llms import OpenAI
from dotenv import load_dotenv
import os
import streamlit as st
import pandas as pd

def main():
    load_dotenv()

    # Load the OpenAI API key from the environment variable
    api_key = os.getenv("OPENAI_API_KEY")
    if api_key is None or api_key == "":
        st.error("OPENAI_API_KEY is not set")
        return

    st.set_page_config(page_title="Insightly")
    st.sidebar.image("/home/oem/Downloads/insightly_wbg.png", use_column_width=True)
    st.header("Data Analysis 📈")

    csv_files = st.file_uploader("Upload CSV files", type="csv", accept_multiple_files=True)
    if csv_files:
        llm = OpenAI(temperature=0)
        user_input = st.text_input("Question here:")

        # Iterate over each CSV file
        for csv_file in csv_files:
            with NamedTemporaryFile(delete=False) as f:
                f.write(csv_file.getvalue())
                f.flush()
                df = pd.read_csv(f.name)

                # Perform any necessary data preprocessing or feature engineering here
                # You can modify the code based on your specific requirements

                # Example: Accessing columns from the DataFrame
                # column_data = df["column_name"]

                # Example: Applying transformations or calculations to the data
                # transformed_data = column_data.apply(lambda x: x * 2)

                # Example: Using the preprocessed data with the OpenAI API
                # llm_response = llm.predict(transformed_data)

                if user_input:
                    # Pass the user input to the OpenAI agent for processing
                    agent = create_csv_agent(llm, f.name, verbose=True)
                    response = agent.run(user_input)

                    st.write(f"CSV File: {csv_file.name}")
                    st.write("Response:")
                    st.write(response)

if __name__ == "__main__":
    main()
"""

# Retrieve the embeddings
response = openai.Completion.create(
    model="gpt-3.5-turbo",
    documents=[code],
    num_completions=1,
    return_prompt=True,
    return_sequences=False,
    expand_prompt=False
)

# Extract the embeddings from the response
embeddings = response.choices[0].embedding

# Print the embeddings
print(embeddings)