from tempfile import NamedTemporaryFile
from langchain.agents import create_csv_agent
from langchain.llms import OpenAI
from dotenv import load_dotenv
import os
import streamlit as st
import pandas as pd

# Set the page configuration here
st.set_page_config(page_title="Insightly")

def main():
    load_dotenv()

    # Load the OpenAI API key from the environment variable
    api_key = os.getenv("OPENAI_API_KEY")
    if api_key is None or api_key == "":
        st.error("OPENAI_API_KEY is not set")
        return

    st.sidebar.image("https://i.ibb.co/bX6GdqG/insightly-wbg.png", use_column_width=True)
    st.title("Data Analysis 📈")

    csv_files = st.file_uploader("Upload CSV files", type="csv", accept_multiple_files=True)
    if csv_files:
        llm = OpenAI(api_key=api_key, temperature=0, max_tokens=1000)  # Adjust max_tokens as needed
        user_input = st.text_input("Question here:")

        # Iterate over each CSV file
        for csv_file in csv_files:
            with NamedTemporaryFile(delete=False) as f:
                f.write(csv_file.getvalue())
                f.flush()
                df = pd.read_csv(f.name)

                # Perform any necessary data preprocessing or feature engineering here
                # You can modify the code based on your specific requirements

                if user_input:
                    # Pass the user input to the OpenAI agent for processing
                    agent = create_csv_agent(llm, f.name, verbose=True)
                    response = agent.run(user_input)

                    st.write(f"CSV File: {csv_file.name}")
                    st.write("Response:")

                    # Create a foldable section for long outputs
                    with st.beta_expander("Show Full Response"):
                        st.write(response)

# Add links to the sidebar with the same spacing properties
    st.sidebar.markdown("<p class='sidebar-link'>📚  <a href='https://chandrakalagowda-demo2.hf.space/'>  PDF Bot </a></p>", unsafe_allow_html=True)
    st.sidebar.markdown("<p class='sidebar-link'>🖼️  <a href='https://insightly-image-reader.hf.space'>  Image Reader</a></p>", unsafe_allow_html=True)
    st.sidebar.markdown("<p class='sidebar-link'>📸  <a href='https://insightly-frame-capturer.hf.space/'>  Frame Capturer</a></p>", unsafe_allow_html=True)

# Custom CSS to style the link and create vertical space
    st.markdown(
        """
        <style>
        .image-container {
            margin-bottom: 60px;
        }
        .sidebar-link {
            display: flex;
            justify-content: left;
            font-size: 28px;
            margin-top: 20px;
            margin-left: 10px;
        }
        .vertical-space {
            height: 20px;
        }
        </style>
        """,
        unsafe_allow_html=True,
    )

if __name__ == "__main__":
    main()
