import re
import requests
from enum import Enum
from dataclasses import dataclass


@dataclass
class ModelInfo:
    name: str
    symbol: str  # emoji


class ModelType(Enum):
    PT = ModelInfo(name="pretrained", symbol="🟢")
    FT = ModelInfo(name="fine-tuned", symbol="🔶")
    IFT = ModelInfo(name="instruction-tuned", symbol="⭕")
    RL = ModelInfo(name="RL-tuned", symbol="🟦")
    Unknown = ModelInfo(name="Unknown, add type to request file!", symbol="❓")

    def to_str(self, separator=" "):
        return f"{self.value.symbol}{separator}{self.value.name}"


text = requests.get(
    "https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard/raw/main/src/display_models/model_metadata_type.py"
).text

dicts = re.findall(r"\{.*?\}", text, re.DOTALL)

MODEL_TYPES = eval(max(dicts, key=len))
MODEL_TYPES
