import gradio as gr
import numpy as np
from huggingface_hub import from_pretrained_keras

model = from_pretrained_keras("vladimirchabanov/digits")

def greet(img):
  img = np.expand_dims(img, axis = 0)
  return np.argmax(model.predict(img)[0])


demo = gr.Interface(fn=greet, inputs="sketchpad", outputs="text")
demo.launch()