import tensorflow as tf
import gradio as gr
import numpy as np

modelo =tf.keras.models.load_model('model_0.h5')
#modelo.load_weights("model_0_weights.h5")
classes=['daisy','dandelion','roses','sunflowers','tulips']

def classifier(image): 
  pred_img = modelo.predict(tf.expand_dims(image,axis=0))
  pred_img = tf.squeeze(tf.round(pred_img))
  texto = str(f'Predicted label: {classes[(np.argmax(pred_img))]}!!!')
  return texto

interface = gr.Interface(classifier,gr.inputs.Image(shape=(180,180)),outputs = "text",
                          description="Classifier of images of daisy plants, dandelion, roses, sunflowers, and tulips",
                          title="Flower Image Classifier",
                          examples=[['1022552036_67d33d5bd8_n.jpg'],['142218310_d06005030a_n.jpg'],
                          ['2077865117_9ed85191ae_n.jpg'],['3500121696_5b6a69effb_n.jpg'],['4675287055_5938ed62c4.jpg']])
interface.launch()
  