import cv2
import numpy as np
import gradio as gr

def imagen(image):
    image= cv2.cvtColor(image,cv2.COLOR_BGR2RGB)
    grayImage = cv2.cvtColor(image, cv2.COLOR_RGB2GRAY)
    grayImage = cv2.GaussianBlur(grayImage, (3, 3), 0)
    edgeImage = cv2.Laplacian(grayImage, -1, ksize=5)
    edgeImage = 255 - edgeImage
    ret, edgeImage = cv2.threshold(edgeImage, 150, 255, cv2.THRESH_BINARY)
    edgePreservingImage = cv2.edgePreservingFilter(image, flags=2, sigma_s=50, sigma_r=0.4)
    output = np.zeros(grayImage.shape)
    output = cv2.bitwise_and(edgePreservingImage, edgePreservingImage, mask=edgeImage)
    candidate = cv2.cvtColor(output,cv2.COLOR_RGB2BGR)
    return candidate

interface = gr.Interface(imagen,
            inputs = gr.inputs.Image(shape=(1024,1024)),
            outputs = "image",
            title="Gamify your photo")
interface.launch(inline=False)