# import required libraries
from transformers import pipeline
import gradio as gr
import timm

# build gradio interface
model = pipeline("image-classification")
examples = ["birdA.jpg", "birdB.jpg", "birdC.jpg"]
gr.Interface.from_pipeline(model,
                           title = "tellme.ai",
                           examples = examples,
                           theme = gr.themes.Soft(),
                           css=".gradio-container {background: url('file=blue.jpg')}").launch()